/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 13, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets.dialogs;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * @author      DNS
 *
 */
public class ConfirmationDialog
extends Window
{
	
	/**
	 * Displays a modal dialog with an OK button
	 * @param title
	 * @param message
	 * @param includeOkButton
	 * @param okButtonClickHandler
	 */
	/*
	public ConfirmationDialog(String title, String message, ClickHandler okButtonClickHandler)
	{
		this.setWidth(360);  
		this.setHeight(185);  
		this.setTitle(title);  
		this.setShowMinimizeButton(false);
		this.setShowCloseButton(false);
		this.setIsModal(true);  
		this.setShowModalMask(true);  
		this.centerInPage();  
        
        Label label = new Label(message);  
        //label.setHeight100();
        label.setHeight("*");
        label.setPadding(5);
        label.setValign(VerticalAlignment.TOP);  
        label.setWrap(true);
        
        this.addItem(label);  
        if(okButtonClickHandler != null)
        {
        	IButton button = new IButton("OK");
        	button.setLayoutAlign(Alignment.CENTER);
        	button.setPadding(3);
        	button.addClickHandler(okButtonClickHandler);
        	this.addItem(button);
        } 
	}*/
	
	private ConfirmationDialog(String title, String message, ClickHandler okButtonClickHandler)
	{
		super();
		setWidth(360);  
		setHeight(155);  
		setAutoSize(true);
		setTitle(title);  
		setShowMinimizeButton(false);
		setShowCloseButton(false);
		setIsModal(true);  
		setShowModalMask(true);  
		centerInPage();  
        
        Label label = new Label(message);  
        //label.setHeight100();
        label.setHeight("*");
        label.setPadding(5);  
        label.setValign(VerticalAlignment.TOP);
        label.setCanSelectText(true);
        //label.setOverflow(Overflow.AUTO);
        label.setWrap(true);
        
        Label emptyLabel = new Label();
		emptyLabel.setHeight("*");

        VLayout layout = new VLayout();
        layout.setHeight100();
        layout.setWidth100();
        
        IButton button  = null;        
        if(okButtonClickHandler != null)
        {  
	        button = new IButton("OK");
	        button.setMargin(2);
	    	button.setLayoutAlign(Alignment.CENTER);
	    	button.setValign(VerticalAlignment.CENTER);
	    	button.addClickHandler(okButtonClickHandler);
        }
    	
    	layout.addMember(label);
    	layout.addMember(emptyLabel);
    	if(button != null)
    	{
    		layout.addMember(button);
    	}
    	this.addItem(layout);
	}
	
	public static ConfirmationDialog createDialog(String title, String message, ClickHandler okButtonClickHandler)
	{
		ConfirmationDialog dialog = new ConfirmationDialog(title, message, okButtonClickHandler);
		return dialog;
	}
	
	public static ConfirmationDialog createOkButtonCloseDialog(String title, String message)
	{
		CloseDialogClickHandler handler = new CloseDialogClickHandler();
		ConfirmationDialog dialog = 
			new ConfirmationDialog(title, message, handler);
		handler.setWindow(dialog);
		return dialog;
	}

	/*
	public ConfirmationDialog(String title, String message, 
			boolean okButtonClose)
	{
		this(title, message, true, new CloseDialogClickHandler(this));
	}
	
	public static ConfirmationDialog createOkButtonCloseDialog(String title, String message)
	{
		ConfirmationDialog dialog = new ConfirmationDialog(title, message, true, new clickhan)
	}*/

	static class CloseDialogClickHandler 
	implements ClickHandler
	{
		private Window window = null;
		
		public CloseDialogClickHandler()
		{
			super();
		}

		/**
		 * @return the window
		 */
		public Window getWindow()
		{
			return window;
		}

		/**
		 * @param window the window to set
		 */
		public void setWindow(Window window)
		{
			this.window = window;
		}

		@Override
		public void onClick(ClickEvent event)
		{
			if(this.window != null)
				this.window.destroy();
		}
		
	}
	
}
