/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 27, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import java.util.logging.Logger;

import gov.va.med.imaging.awiv.business.AwivImage;
import gov.va.med.imaging.awiv.business.AwivStudyDetails;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.PatientStudyServiceDao;
import gov.va.med.imaging.awiv.client.ui.data.ImageRecord;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

import com.google.gwt.user.client.Window.Location;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;
import com.smartgwt.client.widgets.tile.TileGrid;
import com.smartgwt.client.widgets.viewer.DetailViewerField;

/**
 * This tab is experimental and not part of patch 124. This tab was supposed to show the images in a group of images
 * 
 * @author       DNS
 *
 */
public class StudyTab
extends Tab
implements AwivTab
{
	private Patient patient;
	private StudyRecord studyRecord;
	private AwivUserInformation awivUserInformation;
	private TileGrid imagesGrid = new TileGrid();  
	private static Logger logger = Logger.getLogger("");
	
	public StudyTab()
	{
		super();
		VLayout layout = new VLayout();
		layout.setWidth100();
		layout.setHeight100();
		
		
		imagesGrid.setTileWidth(194);  
		imagesGrid.setTileHeight(165);
		imagesGrid.setWidth100();
		imagesGrid.setHeight100();
		imagesGrid.setCanReorderTiles(false);
		imagesGrid.setShowAllRecords(false);
		
		DetailViewerField thumbnailField = new DetailViewerField("imageIdentifier");
		thumbnailField.setType("image");  
		
		String imageUrlPrefix = Location.getProtocol() + "//" + Location.getHost() + "/Awiv/thumbnail/";
		logger.info("ImageURLPrefix: " + imageUrlPrefix);
		thumbnailField.setImageURLPrefix(imageUrlPrefix);
		//thumbnailField.setImageURLPrefix("http://localhost:8080/Awiv/thumbnail/");
		thumbnailField.setImageWidth(186);  
		thumbnailField.setImageHeight(120);  
		
		//DetailViewerField procedureField = new DetailViewerField("procedure");  
		DetailViewerField procedureField = new DetailViewerField("imageIdentifier");
        //DetailViewerField procedureDateField = new DetailViewerField("procedureDate");  
		
        imagesGrid.setFields(thumbnailField, procedureField);//, procedureDateField);
        //imagesGrid.setFields(procedureField);//, procedureDateField);
        
		this.setCanClose(true);
		layout.addMember(imagesGrid);
		this.setPane(layout);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.ui.widgets.AwivTab#getCreationIndex()
	 */
	@Override
	public int getCreationIndex()
	{
		return 2;
	}
	
	/**
	 * @return the patient
	 */
	public Patient getPatient()
	{
		return patient;
	}

	/**
	 * @param patient the patient to set
	 */
	public void setPatient(Patient patient)
	{
		this.patient = patient;
	}

	/**
	 * @return the studyRecord
	 */
	public StudyRecord getStudyRecord()
	{
		return studyRecord;
	}

	/**
	 * @param studyRecord the studyRecord to set
	 */
	public void setStudyRecord(StudyRecord studyRecord)
	{
		this.studyRecord = studyRecord;
	}

	/**
	 * @return the awivUserInformation
	 */
	public AwivUserInformation getAwivUserInformation()
	{
		return awivUserInformation;
	}

	/**
	 * @param awivUserInformation the awivUserInformation to set
	 */
	public void setAwivUserInformation(AwivUserInformation awivUserInformation)
	{
		this.awivUserInformation = awivUserInformation;
	}

	public void displayStudy(AwivUserInformation awivUserInformation,
			Patient patient, StudyRecord studyRecord)
	{
		this.patient = patient;
		this.studyRecord = studyRecord;
		this.awivUserInformation = awivUserInformation;
		this.setTitle(this.studyRecord.getShortDescription());
		
		String transactionId = UUID.uuid();
		logger.info("Retrieving images for study '" + studyRecord.getStudyIdentifier() + "' with transaction Id '" + transactionId + "'.");
		WaitDialog.displayWaitDialog("Loading Study Images", "Loading images for study");
		PatientStudyServiceDao.patientStudyServiceDao.getStudyDetails(transactionId, 
				studyRecord.getStudyIdentifier(), new AsyncCallback<AwivStudyDetails>()
		{
			
			@Override
			public void onSuccess(AwivStudyDetails awivStudyDetails)
			{
				WaitDialog.hideWaitDialog();
				
				AwivImage [] awivImages = awivStudyDetails.getAwivImages();
				ImageRecord [] imageRecords = new ImageRecord[awivImages.length];
				for(int i = 0; i < awivImages.length; i++)
				{
					imageRecords[i] = new ImageRecord(awivImages[i]);
					//logger.info("ImageRecord[" + i + "] identifier=" + imageRecords[i].getImageIdentifier());
				}
				
				imagesGrid.setData(imageRecords);
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				logger.severe("Error loading study images, " + arg0.getMessage());
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					AwivHelper.displayErrorMessage("Error loading study images", arg0);
				}
			}
		});		
	}
}
