/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 12, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.client.ui.data.SiteConnectivityState;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;

import com.google.gwt.http.client.Request;
import com.smartgwt.client.types.SelectionType;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;

/**
 * Represents a button on the treating sites toolbar that shows a site the patient has been seen at
 * @author       DNS
 *
 */
public class SiteButton
extends ToolStripButton
{
	private String siteName;
	private String siteNumber;
	private int studyCount;
	private boolean partial;
	private Request request = null;
	private StudyRecord [] records = null;
	
	private SiteConnectivityState siteConnectivityState;
	
	public SiteButton()
	{
		super();
		this.setActionType(SelectionType.BUTTON);
		this.studyCount = 0;
		this.partial = false;
		this.siteConnectivityState = SiteConnectivityState.disconnected;
	}
	
	public SiteButton(String siteName, String siteNumber)
	{
		this();
		this.siteName = siteName;
		this.siteNumber = siteNumber;
		setTitleAndStyle();
	}

	public String getSiteName()
	{
		return siteName;
	}

	public void setSiteName(String siteName)
	{
		this.siteName = siteName;
	}

	public String getSiteNumber()
	{
		return siteNumber;
	}

	public void setSiteNumber(String siteNumber)
	{
		this.siteNumber = siteNumber;
	}	

	public SiteConnectivityState getSiteConnectivityState()
	{
		return siteConnectivityState;
	}

	public void setSiteConnectivityState(SiteConnectivityState siteConnectivityState)
	{
		this.siteConnectivityState = siteConnectivityState;
		setTitleAndStyle();
	}	
	
	public int getStudyCount()
	{
		return studyCount;
	}

	public void setStudyCount(int studyCount)
	{
		this.studyCount = studyCount;
	}

	public boolean isPartial()
	{
		return partial;
	}

	public void setPartial(boolean partial)
	{
		this.partial = partial;
	}

	private void setTitleAndStyle()
	{
		String style = "";
		StringBuilder title = new StringBuilder();
		title.append(this.siteName);		
		if(this.siteConnectivityState == SiteConnectivityState.connected)
		{
			style = "ToolStripButton-Connected";
			if(isPartial())
				title.append(" (Partial)");
			title.append(" [" + this.studyCount + "]");
			this.setIcon(null);
		}
		else if(this.siteConnectivityState == SiteConnectivityState.connecting)
		{
			style = "ToolStripButton-Connected";
			title.append(" [??]");
			this.setIcon("busy_indicator_blu.gif");
		}
		else
		{
			style = "ToolStripButton-Disconnected";
			// disconnected
			title.append(" [XX]");
			this.setIcon(null);
			this.setRecords(null);
		}
		this.setTitle(title.toString());
		setTitleStyle(style);
	}

	public Request getRequest()
	{
		return request;
	}

	public void setRequest(Request request)
	{
		this.request = request;
	}

	public StudyRecord[] getRecords()
	{
		return records;
	}

	public void setRecords(StudyRecord[] records)
	{
		this.records = records;
	}
	
}
