/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 7, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import java.util.logging.Logger;

import gov.va.med.imaging.awiv.business.AwivPatientSensitivity;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.PatientLookupServiceDao;
import gov.va.med.imaging.awiv.client.events.PatientSensitivityCheckCompleteEvent;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;

/**
 * Utilities for checking patient sensitivity and prompting the user for information
 * 
 * @author       DNS
 *
 */
public class PatientSensitivityCheck
{
	private static Logger logger = Logger.getLogger("");
	
	/**
	 * Retrieve the sensitivity for the patient and display the appropriate warning
	 * 
	 * @param awivUserInformation
	 * @param patient
	 * @param patientSensitivityCheckCompleteEvent
	 */
	public static void checkSensitivePatient(AwivUserInformation awivUserInformation, 
			Patient patient, final PatientSensitivityCheckCompleteEvent patientSensitivityCheckCompleteEvent)
	{
		String transactionId = UUID.uuid();
		logger.info("Retrieving patient sensitivity for patient '" + patient.getIcn() + "' from site '" + awivUserInformation.getPatientLookupSiteNumber() + "', with transaction Id '" + transactionId + "'.");
		WaitDialog.displayWaitDialog("Loading Patient Sensitivity Warning", "Loading patient sensitivity warning message");
		PatientLookupServiceDao.patientLookupServiceDao.getPatientSensitivity(transactionId, 
				awivUserInformation.getPatientLookupSiteNumber(), patient.getIcn(), 
				new AsyncCallback<AwivPatientSensitivity>()
		{
			/* (non-Javadoc)
			 * @see com.google.gwt.user.client.rpc.AsyncCallback#onFailure(java.lang.Throwable)
			 */
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				logger.severe("Error loading patient sensitivity, " + arg0.getMessage());
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					AwivHelper.displayErrorMessage("Error loading patient sensitivity", arg0);
				}				
			}

			/* (non-Javadoc)
			 * @see com.google.gwt.user.client.rpc.AsyncCallback#onSuccess(java.lang.Object)
			 */
			@Override
			public void onSuccess(AwivPatientSensitivity awivPatientSensitivity)
			{
				WaitDialog.hideWaitDialog();
				displayPatientSensitivityWarning(awivPatientSensitivity, patientSensitivityCheckCompleteEvent);		
			}
		});
	}
	
	/**
	 * Display a warning message for the known patient sensitivity information
	 * @param awivPatientSensitivity
	 * @param patientSensitivityCheckCompleteEvent
	 */
	public static void displayPatientSensitivityWarning(AwivPatientSensitivity awivPatientSensitivity, 
			final PatientSensitivityCheckCompleteEvent patientSensitivityCheckCompleteEvent)
	{
		final int sensitivityCode = awivPatientSensitivity.getSensitivityCode();
		String warningMessage = awivPatientSensitivity.getWarningMessage();
		switch(sensitivityCode)
		{
			case 0:
				// patient not really sensitive
				patientSensitivityCheckCompleteEvent.onPatientSensitivityCheckComplete(true, sensitivityCode);
				break;
			case 1:
				warningMessage = warningMessage + "<br><br>Access to this patient has been logged. Click 'OK' to continue";
				SC.say("Restricted Patient Record !!!", warningMessage,
						new SensitivePatientBooleanCallback(awivPatientSensitivity, 
								patientSensitivityCheckCompleteEvent));
				break;
			case 2:
				warningMessage = warningMessage + "<br><br>Click 'OK' to Access the Patient. (Access will be logged)";
				SC.confirm("Restricted Patient Record !!!", warningMessage, 
						new SensitivePatientBooleanCallback(awivPatientSensitivity, 
								patientSensitivityCheckCompleteEvent));
				break;
			case 3:
			case 4:
				warningMessage = warningMessage + "<br><br>Access to this restricted patient is Not Allowed.";
				SC.say("Restricted Patient Record !!!", warningMessage,
						new SensitivePatientBooleanCallback(awivPatientSensitivity, 
								patientSensitivityCheckCompleteEvent));
				break;
		}
	}

	static class SensitivePatientBooleanCallback
	implements BooleanCallback
	{
		private final AwivPatientSensitivity awivPatientSensitivity;
		private final PatientSensitivityCheckCompleteEvent patientSensitivityCheckCompleteEvent;
		
		public SensitivePatientBooleanCallback(AwivPatientSensitivity awivPatientSensitivity,
				PatientSensitivityCheckCompleteEvent patientSensitivityCheckCompleteEvent)
		{
			this.awivPatientSensitivity = awivPatientSensitivity;
			this.patientSensitivityCheckCompleteEvent = patientSensitivityCheckCompleteEvent;
		}

		/* (non-Javadoc)
		 * @see com.smartgwt.client.util.BooleanCallback#execute(java.lang.Boolean)
		 */
		@Override
		public void execute(Boolean value)
		{
			int code = awivPatientSensitivity.getSensitivityCode();
			switch(code)
			{
				case 1:
					// user didn't need to agree
					patientSensitivityCheckCompleteEvent.onPatientSensitivityCheckComplete(true, code);
					break;
				case 2:
					if(value != null && value)
					{
						patientSensitivityCheckCompleteEvent.onPatientSensitivityCheckComplete(true, code);						
					}
					else
					{
						patientSensitivityCheckCompleteEvent.onPatientSensitivityCheckComplete(false, code);
					}
					break;
				case 3:
				case 4:
					patientSensitivityCheckCompleteEvent.onPatientSensitivityCheckComplete(false, code);
					break;
			}	
		}
	}
}
