/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.events.PatientClickedEvent;
import gov.va.med.imaging.awiv.client.events.PatientSelectedEvent;
import gov.va.med.imaging.awiv.client.ui.data.PatientRecord;

import com.smartgwt.client.types.SelectionStyle;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.grid.events.RecordClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordClickHandler;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.menu.events.ClickHandler;
import com.smartgwt.client.widgets.menu.events.MenuItemClickEvent;

/**
 * @author       DNS
 * 
 */
public class PatientSelectionListGrid
extends ListGrid
{
	
	private PatientSelectedEvent patientSelectedEvent = null;
	private PatientClickedEvent patientClickedEvent = null;
	private final AwivUserInformation awivUserInformation;

	public PatientSelectionListGrid(AwivUserInformation awivUserInformation)
	{
		super();
		this.awivUserInformation = awivUserInformation;

		this.setShowAllRecords(false);
		this.setCanGroupBy(false);
		this.setCanFreezeFields(false);
		this.setCanMultiSort(false);
		this.setSelectionType(SelectionStyle.SINGLE);
		
		//ListGridField photoIdField = new ListGridField("photoId", "Photo ID", 250);
		ListGridField patientNameField = new ListGridField("patientName", "Patient Name", 320);
		ListGridField ssnField = new ListGridField("ssn", "SSN", 110);
		ListGridField veteranStatusField = new ListGridField("veteranStatus", "Veteran Status", 180);
		ListGridField dobField = new ListGridField("dob", "Date of Birth", 120);
		// if the patient is sensitive then the DOB and SSN fields will be set to null, setting the EmptyCellValue
		// fills in a value for these null fields
		dobField.setEmptyCellValue("*SENSITIVE*");
		ssnField.setEmptyCellValue("*SENSITIVE*");
		
		this.setFields(patientNameField, ssnField, veteranStatusField, dobField);
		this.addRecordDoubleClickHandler(new RecordDoubleClickHandler()
		{
			
			@Override
			public void onRecordDoubleClick(RecordDoubleClickEvent event)
			{
				PatientRecord patientRecord = (PatientRecord) event.getRecord();
				selectPatient(patientRecord);
			}
		});

		this.addRecordClickHandler(new RecordClickHandler()
		{
			
			@Override
			public void onRecordClick(RecordClickEvent event)
			{
				PatientRecord patientRecord = (PatientRecord) event.getRecord();
				clickPatient(patientRecord);
			}
		});
		
		Menu contextMenu = new Menu();
		
		MenuItem selectPatientMenuItem = new MenuItem("Select Patient");
		contextMenu.addItem(selectPatientMenuItem);
		selectPatientMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				PatientRecord patientRecord = (PatientRecord)getSelectedRecord();
				if(patientRecord != null)
				{
					selectPatient(patientRecord);
				}
			}
		});
		
		// only add the context menu if the user is allowed to view patient images
		if(AwivHelper.canUserViewPatients(this.awivUserInformation))
		{
			this.setContextMenu(contextMenu);
		}
	}
	
	private void selectPatient(PatientRecord patientRecord)
	{
		if(this.patientSelectedEvent != null)
		{
			this.patientSelectedEvent.onPatientSelected(patientRecord.getPatient(), true);
		}
	}
	
	private void clickPatient(PatientRecord patientRecord)
	{
		if(this.patientClickedEvent != null)
		{
			patientClickedEvent.onPatientClicked(patientRecord.getPatient());
		}
	}
	
	public void addPatientSelectedHandler(PatientSelectedEvent patientSelectedEvent)
	{
		this.patientSelectedEvent = patientSelectedEvent;
	}
	
	public void addPatientClickedHandler(PatientClickedEvent patientClickedEvent)
	{
		this.patientClickedEvent = patientClickedEvent;
	}
	
	public void setPatients(PatientRecord [] patientRecords)
	{
		this.setData(patientRecords);
	}
	
	/**
	 * Clear the displayed patients 
	 */
	public void clearResults()
	{
		this.setData((ListGridRecord[])null);
	}
}
