/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.client.events.AboutDialogEvent;
import gov.va.med.imaging.awiv.client.events.LogVisibleEvent;
import gov.va.med.imaging.awiv.client.events.UserLogoutEvent;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * @author       DNS
 *
 */
public class Masthead
extends HLayout 
{
	

	public static final int MASTHEAD_HEIGHT = 58;

	private Label userInformation = new Label();
	private final UserLogoutEvent userLogoutEvent;
	private final AboutDialogEvent aboutDialogEvent;
	private final LogVisibleEvent logVisibleEvent;
	private final Label showLogLabel = new Label();
	private boolean logVisible = false;
	  	
	public Masthead(UserLogoutEvent userLogoutEvent,
			AboutDialogEvent aboutDialogEvent, LogVisibleEvent logVisibleEvent)
	{
		super();
		this.userLogoutEvent = userLogoutEvent;
		this.aboutDialogEvent = aboutDialogEvent;
		this.logVisibleEvent = logVisibleEvent;

		// initialise the layout container
		this.setHeight(MASTHEAD_HEIGHT);
		// this.setBackgroundColor("#C3D9FF");
		this.setStyleName("MastHead");

		/*
		 * Img logo = new Img("va_seal2.png", 48, 48);
		 * logo.setStyleName("Masthead-Logo");
		 */

		Label name = new Label();
		name.setStyleName("MastHead-Name");
		name.setWidth("*");
		name.setContents("VistA Imaging AWIV");

		userInformation.setStyleName("MastHead-UserInformation");
		userInformation.setHeight(40);

		String logout = "Logout";
		Label logoutLink = new Label(logout);
		logoutLink.addStyleName("MastHead-UserInformation-Logout");
		logoutLink.setAlign(Alignment.CENTER);

		// Set the width to the length of the text.
		logoutLink.setWidth(logout.length() * 6);
		logoutLink.setMargin(2);

		logoutLink.addClickHandler(new ClickHandler()
		{
			@Override
			public void onClick(ClickEvent event)
			{
				if (Masthead.this.userLogoutEvent != null)
				{
					Masthead.this.userLogoutEvent.OnLogoutUser();
				}
			}
		});

		String about = "About";
		Label aboutLink = new Label(about);
		aboutLink.addStyleName("MastHead-UserInformation-Logout");
		aboutLink.setAlign(Alignment.CENTER);

		// Set the width to the length of the text.
		aboutLink.setWidth(about.length() * 6);
		aboutLink.setMargin(2);
		aboutLink.addClickHandler(new ClickHandler()
		{

			@Override
			public void onClick(ClickEvent event)
			{
				if (Masthead.this.aboutDialogEvent != null)
					Masthead.this.aboutDialogEvent.onShowAboutDialog();
			}
		});

		String showLog = "Log";
		showLogLabel.setContents(showLog);
		showLogLabel.addStyleName("MastHead-UserInformation-Logout");
		showLogLabel.setAlign(Alignment.CENTER);

		// Set the width to the length of the text.
		showLogLabel.setWidth(showLog.length() * 8);
		showLogLabel.setMargin(2);
		showLogLabel.addClickHandler(new ClickHandler()
		{

			@Override
			public void onClick(ClickEvent event)
			{
				setLogVisible(!logVisible);
			}
		});

		HLayout westLayout = new HLayout();
		westLayout.setHeight(MASTHEAD_HEIGHT);
		westLayout.setWidth("50%");
		// westLayout.addMember(logo);
		westLayout.addMember(name);

		VLayout eastLayout = new VLayout();
		eastLayout.setHeight(MASTHEAD_HEIGHT);
		eastLayout.setAlign(Alignment.RIGHT);
		eastLayout.setWidth("50%");
		// eastLayout.setBackgroundColor("orange");

		HLayout linkLayout = new HLayout();
		linkLayout.setWidth100();
		linkLayout.setAlign(Alignment.RIGHT);
		// linkLayout.setBackgroundColor("green");
		linkLayout.setHeight(18);

		linkLayout.addMember(showLogLabel);
		linkLayout.addMember(aboutLink);
		linkLayout.addMember(logoutLink);

		eastLayout.addMember(userInformation);
		eastLayout.addMember(linkLayout);

		this.addMember(westLayout);
		this.addMember(eastLayout);
	}

	public void setUserInformation(AwivUserInformation awivUserInformation)
	{
		StringBuilder sb = new StringBuilder();
		sb.append(awivUserInformation.getName());
		sb.append("<br>");
		sb.append(awivUserInformation.getSiteName() + " ["
				+ awivUserInformation.getSiteNumber() + "]");

		userInformation.setContents(sb.toString());
	}

	private void setLogVisible(boolean visible)
	{
		logVisible = visible;
		//showLogLabel.setContents(visible == true ? "Hide Log" : "Show Log");
		if(logVisibleEvent != null)
			logVisibleEvent.OnDisplayLog(visible);
	}

}
