/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 6, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import java.util.logging.Logger;

import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.PatientStudyServiceDao;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.Window;

/**
 * @author       DNS
 *
 */
public class ImageInformationWindow
extends Window
{
	private final int MAX_IMAGE_HEIGHT = 150;
	private final int MAX_IMAGE_WIDTH = 150;
	
	private static Logger logger = Logger.getLogger("");

	public ImageInformationWindow(Patient patient, StudyRecord studyRecord)
	{
		super();
		
		this.setWidth(360);  
		this.setHeight(215);
		
		this.setTitle("Image Information - " + studyRecord.getStudyIdentifier());  
		this.setShowMinimizeButton(false);
		this.setShowCloseButton(true);
		this.setIsModal(true);  
		this.setShowModalMask(true);  
		this.centerInPage();  
		this.setAlign(Alignment.CENTER);
        
        Label label = new Label(patient.getName());  
        label.setHeight100();  
        label.setPadding(5);  
        label.setValign(VerticalAlignment.TOP);
        
        final Image image = new Image();
        image.addLoadHandler(new LoadHandler()
		{
			
			@Override
			public void onLoad(LoadEvent event)
			{
				 Element element = event.getRelativeElement();
		            if (element == image.getElement()) {
		                int originalHeight = image.getOffsetHeight();
		                int originalWidth = image.getOffsetWidth();
		                if (originalHeight > originalWidth) {
		                    image.setHeight(MAX_IMAGE_HEIGHT + "px");
		                } else {
		                    image.setWidth(MAX_IMAGE_WIDTH + "px");
		                }
		            }
			}
		});
        image.addErrorHandler(new ErrorHandler()
		{
			
			@Override
			public void onError(ErrorEvent arg0)
			{
				image.setAltText("Error loading image");
			}
		});
        logger.info("Retrieving thumbnail image '" + studyRecord.getFirstImageIdentifier() + "'.");
        image.setUrl("/Awiv/thumbnail/" + studyRecord.getFirstImageIdentifier());
        
        
        this.addItem(label);          
        this.addItem(image);
	}

	public static void displayImageInformationWindow(Patient patient, final StudyRecord studyRecord)
	{
		if(studyRecord.getAwivStudy().isDodArtifact())
		{
			displayImageInformationMessage(studyRecord, "Image information not available for DoD artifacts");
			return;
		}
		WaitDialog.displayWaitDialog("Loading Information", "Please wait while loading study information");
		String transactionId = UUID.uuid();
		logger.info("Loading study information for study '" + studyRecord.getStudyIdentifier() + "' with transaction Id '" + transactionId + "'");
		PatientStudyServiceDao.patientStudyServiceDao.getStudyInformation(transactionId, studyRecord.getStudyIdentifier(), 
				new AsyncCallback<String>()
		{
			
			@Override
			public void onSuccess(String studyInformation)
			{
				WaitDialog.hideWaitDialog();
				studyInformation = "URN: " + studyRecord.getStudyIdentifier() + "<br>" + studyInformation;
				displayImageInformationMessage(studyRecord, studyInformation);
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					AwivHelper.displayErrorMessage("Error loading study information", arg0);
				}
			}
		});		
	}
	
	private static void displayImageInformationMessage(StudyRecord studyRecord, String studyInformation)
	{
		SC.say("Image Information - " + studyRecord.getStudyIdentifier(), 
				studyInformation, new BooleanCallback()
		{			
			@Override
			public void execute(Boolean value)
			{
				// do nothing				
			}
		});	
	}	
	
	public static void displayAdvancedImageInformationWindow(Patient patient, StudyRecord studyRecord)
	{
		StringBuilder imageInfo = new StringBuilder();
		imageInfo.append("URN        : " + studyRecord.getStudyIdentifier());
		imageInfo.append("<br>");
		imageInfo.append("Short Desc : " + studyRecord.getShortDescription());
		imageInfo.append("<br>");
		imageInfo.append("Image Type : " + studyRecord.getAwivStudy().getFirstImage().getImageType());
		imageInfo.append("<br>");
		imageInfo.append("Patient    : " + patient.getName());
		imageInfo.append("<br>");
		imageInfo.append("Proc Date  : " + studyRecord.getProcedureDate());
		imageInfo.append("<br>");
		imageInfo.append("Procedure  : " + studyRecord.getProcedure());
		imageInfo.append("<br>");
		imageInfo.append("Abs Location: " + studyRecord.getAwivStudy().getFirstImage().getAbsLocation());
		imageInfo.append("<br>");
		imageInfo.append("Full Image Accessable/Offline : " + studyRecord.getAwivStudy().getFirstImage().getFullLocation());
		imageInfo.append("<br>");
		imageInfo.append("Sensitive   : " + studyRecord.getAwivStudy().isSensitive());
		imageInfo.append("<br>");
		imageInfo.append("Study View Status : " + studyRecord.getAwivStudy().getStudyViewStatus().getStudyStatus());
		imageInfo.append("<br>");
		imageInfo.append("Has Annotations : " + studyRecord.getAwivStudy().isHasAnnotations());
		displayImageInformationMessage(studyRecord, imageInfo.toString());
	}
}

