/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 9, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.AwivHelper;

import com.smartgwt.client.types.TitleOrientation;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SpinnerItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;

/**
 * @author       DNS
 *
 */
public class DebugTab
extends Tab
implements AwivTab
{
	private TextItem agreedPatientSensitivityLevel = new TextItem();
	private SpinnerItem sessionTimeout = new SpinnerItem();
	
	public DebugTab()
	{
		super();
		setTitle("Debug");
		setCanClose(false);
		
		DynamicForm form = new DynamicForm();
		form.setWidth100();
		form.setHeight("*");
		
		form.setTitleOrientation(TitleOrientation.LEFT);
		
		
		agreedPatientSensitivityLevel.setTitle("Patient Sensitivity Level");
		agreedPatientSensitivityLevel.setWidth("*");
		
		sessionTimeout.setTitle("Session Timeout");
		sessionTimeout.setDefaultValue(AwivHelper.getSessionTimeout());
		sessionTimeout.setStep(1);
		sessionTimeout.setMin(1);
		sessionTimeout.setMax(19);
		
		form.setFields(agreedPatientSensitivityLevel, sessionTimeout);
		
		VLayout layout = new VLayout();
		layout.setWidth100();
		layout.setHeight100();
		
		IButton saveButton = new IButton("Save");
		saveButton.addClickHandler(new ClickHandler()
		{			
			@Override
			public void onClick(ClickEvent event)
			{
				SC.say("This doesn't do anything yet...");
			}
		});
		
		layout.addMember(form);
		layout.addMember(saveButton);
		this.setPane(layout);
		
		
	}
	

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.ui.widgets.AwivTab#getCreationIndex()
	 */
	@Override
	public int getCreationIndex()
	{
		return 0;
	}

	public void setPatient(Patient patient)
	{
		agreedPatientSensitivityLevel.setValue(patient.getAgreedSensitiveCode());
	}
}
