/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.client.events.ShowPatientSelectEvent;
import gov.va.med.imaging.awiv.client.events.UserLogoutEvent;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.ConfirmationDialog;

import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuBar;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.menu.MenuItemSeparator;
import com.smartgwt.client.widgets.menu.events.ClickHandler;
import com.smartgwt.client.widgets.menu.events.MenuItemClickEvent;

/**
 * @author       DNS
 * 
 */
public class ApplicationMenu
		extends HLayout
{

	public static final int APPLICATION_MENU_HEIGHT = 27;
	private static final int DEFAULT_MENU_WIDTH = 70;
	private static final int DEFAULT_SHADOW_DEPTH = 10;

	private MenuBar menuBar;
	private int positionCount = 0;
	private final ShowPatientSelectEvent showPatientSelectEvent;
	private final UserLogoutEvent userLogoutEvent;

	public ApplicationMenu(ShowPatientSelectEvent showPatientSelectEvent, UserLogoutEvent userLogoutEvent)
	{
		super();
		this.showPatientSelectEvent = showPatientSelectEvent;
		this.userLogoutEvent = userLogoutEvent;

		// initialise the layout container
		this.setHeight(APPLICATION_MENU_HEIGHT);
		this.addStyleName("ApplicationMenu");
		this.setBackgroundColor("#4096EE");

		// initialise the Menu Bar
		menuBar = new MenuBar();

		// add the Menu Bar to the Application Menu layout container
		this.addMember(menuBar);
		setMenuItems();
	}
	
	private void setMenuItems()
	{
		Menu fileMenu = new Menu();
		fileMenu.setTitle("File");
		fileMenu.setShowShadow(true);
		fileMenu.setShadowDepth(DEFAULT_SHADOW_DEPTH);
		fileMenu.setWidth(DEFAULT_MENU_WIDTH);
		
		MenuItem logoutMenu = new MenuItem("Logout");
		logoutMenu.addClickHandler(new ClickHandler()
		{			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				if(userLogoutEvent != null)
				{
					userLogoutEvent.OnLogoutUser();
				}
				
			}
		});
		fileMenu.addItem(logoutMenu);
		MenuItemSeparator separator = new MenuItemSeparator();
		fileMenu.addItem(separator);
		
		MenuItem selectPatientMenuItem = new MenuItem("Select Patient");
		selectPatientMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				if(showPatientSelectEvent != null)
				{
					showPatientSelectEvent.OnShowPatientSelect();
				}	
			}
		});
		fileMenu.addItem(selectPatientMenuItem);
		
		Menu helpMenu = new Menu();
		helpMenu.setTitle("Help");
		helpMenu.setShowShadow(true);
		helpMenu.setShadowDepth(DEFAULT_SHADOW_DEPTH);
		helpMenu.setWidth(DEFAULT_MENU_WIDTH);
		
		MenuItem aboutMenuItem = new MenuItem("About");
		helpMenu.addItem(aboutMenuItem);
		aboutMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				ConfirmationDialog aboutDialog = ConfirmationDialog.createOkButtonCloseDialog("About", 
						"<b>AWIV Web Client</b><br>Version 1.0<br>VistA Imaging");
				aboutDialog.show();				
				
				/*
				Window window = new Window();  
				window.setWidth(360);  
                window.setHeight(115);  
                window.setTitle("About");  
                window.setShowMinimizeButton(false);  
                window.setIsModal(true);  
                window.setShowModalMask(true);  
                window.centerInPage();  
                
                Label label = new Label("<b>AWIV Web Client</b><br>Version 1.0<br>VistA Imaging");  
                label.setHeight100();  
                label.setPadding(5);  
                label.setValign(VerticalAlignment.TOP);  
                
                window.addItem(label);  
                
                window.show();
				*/
				
			}
		});
		
		Menu[] menus = new Menu[2];
		menus[0] = fileMenu;
		menus[1] = helpMenu;
		
		menuBar.addMenus(menus, positionCount);
		positionCount += menus.length;
	}

}
