/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 12, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.data;

import gov.va.med.imaging.awiv.business.AwivStudy;

import java.util.Date;

import com.smartgwt.client.widgets.grid.ListGridRecord;

/**
 * @author       DNS
 *
 */
public class StudyRecord
extends ListGridRecord
{
	private final AwivStudy awivStudy;
	
	/*
	public StudyRecord()
	{
		super();
	}*/
	
	
	
	public StudyRecord(AwivStudy awivStudy)
	{		
		this.awivStudy = awivStudy;
		setSiteNumber(awivStudy.getSiteNumber());
		setStudyIdentifier(awivStudy.getStudyIdentifier());
		setProcedure(awivStudy.getProcedureName());
		setProcedureDate(awivStudy.getProcedureDate());
		setSiteAbbr(awivStudy.getSiteAbbr());
		setImageCount(awivStudy.getImageCount());
		setShortDescription(awivStudy.getShortDescription());
		setStudyPackage(awivStudy.getStudyPackage());
		setStudyClass(awivStudy.getStudyClass());
		setStudyType(awivStudy.getStudyType());
		setStudySpecialty(awivStudy.getStudySpecialty());
		// first check if study is not viewable
		if(!awivStudy.isStudyViewable())
		{
			String iconFile = null;
			switch(awivStudy.getStudyViewStatus().getStudyStatus())
			{
				// only showing an icon for non-viewable types (values >= 10)
				case 10:
					iconFile = "10_InProgress.gif";
					break;
				case 11:
					iconFile = "11_NeedsReview.gif";
					break;
				case 12:
					iconFile = "12_Deleted.gif";
					break;
				case 21:
					iconFile = "21_QuestionableIntegrity.gif";
					break;
				case 22:
					iconFile = "22_TIUAuthorizationBlock.gif";
					break;
				case 23:
					iconFile = "23_RadExamStatusBlock.gif";
					break;
			}
			setIcon(iconFile);
		}
		else if(awivStudy.isSensitive())
		{
			// study is viewable but sensitive
			setIcon("sensitive.gif");
		}
		else
		{
			// study is viewable and not sensitive, check for annotations
			setIcon(awivStudy.isHasAnnotations() == true ? "annotation.gif" : null);
		}
	}	
	
	/**
	 * @return the awivStudy
	 */
	public AwivStudy getAwivStudy()
	{
		return awivStudy;
	}
	
	public String getFirstImageIdentifier()
	{
		return awivStudy.getFirstImageIdentifier();
	}

	public String getPatientName()
	{
		return awivStudy.getPatientName();
	}
	
	public String getPatientIcn()
	{
		return awivStudy.getPatientIcn();
	}
	
	public void setSiteNumber(String siteNumber)
	{
		setAttribute("siteNumber", siteNumber);
	}
	
	public String getSiteNumber()
	{
		return getAttributeAsString("siteNumber");
	}
	
	public void setStudySpecialty(String studySpecialty)
	{
		setAttribute("studySpecialty", studySpecialty);
	}
	
	public String getStudySpecialty()
	{
		return getAttributeAsString("studySpecialty");
	}
	
	public void setStudyType(String studyType)
	{
		setAttribute("studyType", studyType);
	}
	
	public String getStudyType()
	{
		return getAttributeAsString("studyType");
	}
	
	public void setStudyClass(String studyClass)
	{
		setAttribute("studyClass", studyClass);
	}
	
	public String getStudyClass()
	{
		return getAttributeAsString("studyClass");
	}
	
	public void setStudyPackage(String studyPackage)
	{
		setAttribute("studyPackage", studyPackage);
	}
	
	public String getStudyPackage()
	{
		return getAttributeAsString("studyPackage");
	}
	
	public void setShortDescription(String shortDescription)
	{
		setAttribute("shortDescription", shortDescription);
	}
	
	public String getShortDescription()
	{
		return getAttributeAsString("shortDescription");
	}
	
	public void setImageCount(int imageCount)
	{
		setAttribute("imageCount", imageCount);
	}
	
	public int getImageCount()
	{
		return getAttributeAsInt("imageCount");
	}
	
	public void setSiteAbbr(String siteAbbr)
	{
		setAttribute("siteAbbr", siteAbbr);
	}
	
	public String getSiteAbbr()
	{
		return getAttributeAsString("siteAbbr");
	}
	
	public void setStudyIdentifier(String studyIdentifier)
	{
		setAttribute("studyIdentifier", studyIdentifier);
	}
	
	public String getStudyIdentifier()
	{
		return getAttributeAsString("studyIdentifier");
	}
	
	public void setProcedure(String procedure)
	{
		setAttribute("procedure", procedure);
	}
	
	public String getProcedure()
	{
		return getAttributeAsString("procedure");
	}
	
	public void setProcedureDate(Date procedureDate)
	{
		setAttribute("procedureDate", procedureDate);
	}
	
	public Date getProcedureDate()
	{
		return getAttributeAsDate("procedureDate");
	}
	
	public void setIcon(String icon)
	{
		setAttribute("icon", icon);
	}
	
	public String getIcon()
	{
		return getAttributeAsString("icon");
	}

}
