/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 27, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.data;

import gov.va.med.imaging.awiv.business.AwivImage;

import com.google.gwt.http.client.URL;
import com.smartgwt.client.widgets.tile.TileRecord;

/**
 * @author       DNS
 *
 */
public class ImageRecord
extends TileRecord
{
	
	private final AwivImage awivImage;
	
	public ImageRecord(AwivImage awivImage)
	{
		super();
		this.awivImage = awivImage;
		//setImageIdentifier("http://tomcat.apache.org/tomcat-6.0-doc/images/tomcat.gif");
		setImageIdentifier(URL.encode(awivImage.getImageIdentifier()));
	}
	
	/**
	 * @return the awivImage
	 */
	public AwivImage getAwivImage()
	{
		return awivImage;
	}

	public void setImageIdentifier(String imageIdentifier)
	{
		setAttribute("imageIdentifier", imageIdentifier);
	}
	
	public String getImageIdentifier()
	{
		return getAttributeAsString("imageIdentifier");
	}

}
