/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 9, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.dao;

import com.google.gwt.user.client.rpc.AsyncCallback;

import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.UserService;
import gov.va.med.imaging.awiv.client.UserServiceAsync;

/**
 * @author       DNS
 *
 */
public class UserServiceDao
implements UserServiceAsync
{
	
	public final static UserServiceDao userServiceDao = new UserServiceDao();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.UserServiceAsync#getUserInformation(java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getUserInformation(String transactionId,
			AsyncCallback<AwivUserInformation> callback)
	{
		UserServiceAsync userService = UserService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		userService.getUserInformation(transactionId, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.UserServiceAsync#getPatientLookupSites(java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getPatientLookupSites(String transactionId,
			AsyncCallback<AwivSite[]> callback)
	{
		UserServiceAsync userService = UserService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		userService.getPatientLookupSites(transactionId, callback);
	}
}
