/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 21, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.dao;

import com.google.gwt.user.client.rpc.AsyncCallback;

import gov.va.med.imaging.awiv.business.AwivAuthenticationSitesInformation;
import gov.va.med.imaging.awiv.business.AwivWelcomeMessage;
import gov.va.med.imaging.awiv.client.UserAuthenticationService;
import gov.va.med.imaging.awiv.client.UserAuthenticationServiceAsync;

/**
 * @author       DNS
 *
 */
public class UserAuthenticationDao
implements UserAuthenticationServiceAsync
{
	public final static UserAuthenticationDao userAuthenticationDao = 
		new UserAuthenticationDao();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.UserAuthenticationServiceAsync#authenticateUser(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void authenticateUser(String transactionId, String siteNumber, String username,
			String password, AsyncCallback<Boolean> callback)
	{
		UserAuthenticationServiceAsync userAuthenticationService = UserAuthenticationService.Util.getInstance();
		userAuthenticationService.authenticateUser(transactionId, siteNumber, username, password, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.UserAuthenticationServiceAsync#getWelcomeMessage(java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getWelcomeMessage(String transactionId, String siteNumber,
			AsyncCallback<AwivWelcomeMessage> callback)
	{
		UserAuthenticationServiceAsync userAuthenticationService = UserAuthenticationService.Util.getInstance();
		userAuthenticationService.getWelcomeMessage(transactionId, siteNumber, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.UserAuthenticationServiceAsync#getUserAuthenticationSites(java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getUserAuthenticationSites(String transactionId,
			AsyncCallback<AwivAuthenticationSitesInformation> callback)
	{
		UserAuthenticationServiceAsync userAuthenticationService = UserAuthenticationService.Util.getInstance();
		userAuthenticationService.getUserAuthenticationSites(transactionId, callback);
	}

}
