/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 9, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.dao;

import com.google.gwt.http.client.Request;
import com.google.gwt.user.client.rpc.AsyncCallback;

import gov.va.med.imaging.awiv.business.AwivArtifactResults;
import gov.va.med.imaging.awiv.business.AwivStudyDetails;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.PatientStudyService;
import gov.va.med.imaging.awiv.client.PatientStudyServiceAsync;

/**
 * @author       DNS
 *
 */
public class PatientStudyServiceDao
implements PatientStudyServiceAsync
{
	public final static PatientStudyServiceDao patientStudyServiceDao = 
		new PatientStudyServiceDao();	

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientStudyServiceAsync#getPatientStudies(java.lang.String, java.lang.String, java.lang.String, int, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public Request getPatientStudies(String transactionId, String patientIcn,
			String routingTokenString, int maximumAllowedSensitivity, String cls,
			AsyncCallback<AwivArtifactResults> callback)
	{
		PatientStudyServiceAsync patientStudyService = PatientStudyService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		return patientStudyService.getPatientStudies(transactionId, patientIcn, routingTokenString, 
				maximumAllowedSensitivity, cls, callback);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientStudyServiceAsync#getStudyReport(java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getStudyReport(String transactionId, String studyIdentifier,
			AsyncCallback<String> callback)
	{
		PatientStudyServiceAsync patientStudyService = PatientStudyService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientStudyService.getStudyReport(transactionId, studyIdentifier, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientStudyServiceAsync#getStudyDetails(java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getStudyDetails(String transactionId, String studyIdentifier,
			AsyncCallback<AwivStudyDetails> callback)
	{
		PatientStudyServiceAsync patientStudyService = PatientStudyService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientStudyService.getStudyDetails(transactionId, studyIdentifier, callback);
	}

	@Override
	public void getStudyInformation(String transactionId,
			String studyIdentifier, AsyncCallback<String> callback)
	{
		PatientStudyServiceAsync patientStudyService = PatientStudyService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientStudyService.getStudyInformation(transactionId, studyIdentifier, callback);
	}

}
