/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 9, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:       DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.dao;

import com.google.gwt.user.client.rpc.AsyncCallback;

import gov.va.med.imaging.awiv.business.AwivMeansTestResult;
import gov.va.med.imaging.awiv.business.AwivPatientSensitivity;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.PatientLookupService;
import gov.va.med.imaging.awiv.client.PatientLookupServiceAsync;

/**
 * @author       DNS
 *
 */
public class PatientLookupServiceDao
implements PatientLookupServiceAsync
{
	
	public final static PatientLookupServiceDao patientLookupServiceDao = 
		new PatientLookupServiceDao();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupServiceAsync#search(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void search(String transactionId, String siteNumber,
			String searchString, AsyncCallback<Patient[]> callback)
	{
		PatientLookupServiceAsync patientLookupService = PatientLookupService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientLookupService.search(transactionId, siteNumber, searchString, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupServiceAsync#getPatientInformation(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getPatientInformation(String transactionId, String siteNumber,
			String patientIcn, AsyncCallback<Patient> callback)
	{
		PatientLookupServiceAsync patientLookupService = PatientLookupService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientLookupService.getPatientInformation(transactionId, siteNumber, patientIcn, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupServiceAsync#getPatientSensitivity(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getPatientSensitivity(String transactionId, String siteNumber,
			String patientIcn, AsyncCallback<AwivPatientSensitivity> callback)
	{
		PatientLookupServiceAsync patientLookupService = PatientLookupService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientLookupService.getPatientSensitivity(transactionId, siteNumber, patientIcn, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupServiceAsync#logPatientSensitiveAccess(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void logPatientSensitiveAccess(String transactionId,
			String siteNumber, String patientIcn,
			AsyncCallback<Boolean> callback)
	{
		PatientLookupServiceAsync patientLookupService = PatientLookupService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientLookupService.logPatientSensitiveAccess(transactionId, siteNumber, patientIcn, callback);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupServiceAsync#getPatientMeansTest(java.lang.String, java.lang.String, java.lang.String, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getPatientMeansTest(String transactionId, String siteNumber,
			String patientIcn, AsyncCallback<AwivMeansTestResult> callback)
	{
		PatientLookupServiceAsync patientLookupService = PatientLookupService.Util.getInstance();
		AwivHelper.resetSessionTimer();
		patientLookupService.getPatientMeansTest(transactionId, siteNumber, patientIcn, callback);
	}
	
	

}
