/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client;

import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface UserServiceAsync 
{
	/**
	 * get information about the logged in user
	 * 
	 * @param transactionId
	 * @throws AwivConnectionException
	 * @throws AwivMethodException
	 * @throws AwivUserNotLoggedInException
	 */
	public void getUserInformation(String transactionId, AsyncCallback<AwivUserInformation> callback);	
	
	/**
	 * Retrieve the list of sites to do a patient lookup against.  These should come from the site service and should not include the DoD, Claims, CVIX
	 * @param transactionId
	 * @throws AwivConnectionException
	 * @throws AwivMethodException
	 */
	public void getPatientLookupSites(String transactionId, AsyncCallback<AwivSite []> callback);
}
