/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client;

import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;
import gov.va.med.imaging.awiv.exceptions.AwivUserNotLoggedInException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("UserService")
public interface UserService 
extends RemoteService 
{
	/**
	 * Utility class for simplifying access to the instance of async service.
	 */
	public static class Util {
		private static UserServiceAsync instance;
		public static UserServiceAsync getInstance(){
			if (instance == null) {
				instance = GWT.create(UserService.class);
			}
			return instance;
		}
	}
	
	/**
	 * get information about the logged in user
	 * 
	 * @param transactionId
	 * @return
	 * @throws AwivConnectionException
	 * @throws AwivMethodException
	 * @throws AwivUserNotLoggedInException
	 */
	public AwivUserInformation getUserInformation(String transactionId)
	throws AwivConnectionException, AwivMethodException, AwivUserNotLoggedInException;	
	
	/**
	 * Retrieve the list of sites to do a patient lookup against.  These should come from the site service and should not include the DoD, Claims, CVIX
	 * @param transactionId
	 * @return
	 * @throws AwivConnectionException
	 * @throws AwivMethodException
	 */
	public AwivSite [] getPatientLookupSites(String transactionId)
	throws AwivConnectionException, AwivMethodException;
}
