/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client;

import gov.va.med.imaging.awiv.business.AwivAuthenticationSitesInformation;
import gov.va.med.imaging.awiv.business.AwivWelcomeMessage;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivCredentialsExpiredException;
import gov.va.med.imaging.awiv.exceptions.AwivInvalidUserCredentialsException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("UserAuthenticationService")
public interface UserAuthenticationService 
extends RemoteService 
{
	/**
	 * Utility class for simplifying access to the instance of async service.
	 */
	public static class Util {
		private static UserAuthenticationServiceAsync instance;
		public static UserAuthenticationServiceAsync getInstance(){
			if (instance == null) {
				instance = GWT.create(UserAuthenticationService.class);
			}
			return instance;
		}
	}
	
	/**
	 * Authenticate the user 
	 * 
	 * @param transactionId
	 * @param siteNumber
	 * @param username
	 * @param password
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 * @throws AwivInvalidUserCredentialsException
	 */
	public boolean authenticateUser(String transactionId, String siteNumber, String username, String password)
	throws AwivMethodException, AwivConnectionException, AwivInvalidUserCredentialsException, AwivCredentialsExpiredException;

	/**
	 * Retrieve the welcome message for a specified site
	 * @param transactionId
	 * @param siteNumber
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 */
	public AwivWelcomeMessage getWelcomeMessage(String transactionId, String siteNumber)
	throws AwivMethodException, AwivConnectionException;
	
	/**
	 * Get the list of authentication sites
	 * 
	 * @param transactionId
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 */
	public AwivAuthenticationSitesInformation getUserAuthenticationSites(String transactionId)
	throws AwivMethodException, AwivConnectionException;
}
