/*
 * Copyright 2011 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.med.imaging.awiv.client;

import gov.va.med.imaging.awiv.business.AwivArtifactResults;
import gov.va.med.imaging.awiv.business.AwivStudyDetails;

import com.google.gwt.http.client.Request;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface PatientStudyServiceAsync 
{
	public Request getPatientStudies(String transactionId, String patientIcn, String routingTokenString, 
			int maximumAllowedSensitivity, String cls, AsyncCallback<AwivArtifactResults> callback);
	
	public void getStudyReport(String transactionId, String studyIdentifier, AsyncCallback<String> callback);
	
	public void getStudyDetails(String transactionId, String studyIdentifier, AsyncCallback<AwivStudyDetails> callback);
	
	public void getStudyInformation(String transactionId, String studyIdentifier, AsyncCallback<String> callback);
	
}
