/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client;

import gov.va.med.imaging.awiv.business.AwivMeansTestResult;
import gov.va.med.imaging.awiv.business.AwivPatientSensitivity;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("PatientLookupService")
public interface PatientLookupService 
extends RemoteService 
{
	/**
	 * Utility class for simplifying access to the instance of async service.
	 */
	public static class Util {
		private static PatientLookupServiceAsync instance;
		public static PatientLookupServiceAsync getInstance(){
			if (instance == null) {
				instance = GWT.create(PatientLookupService.class);
			}
			return instance;
		}
	}
	
	/**
	 * Search for a patient 
	 * @param transactionId
	 * @param siteNumber
	 * @param searchString
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 */
	public Patient[] search(String transactionId, String siteNumber, String searchString)
	throws AwivMethodException, AwivConnectionException;
	
	/**
	 * Get information about a patient
	 * @param transactionId
	 * @param siteNumber
	 * @param patientIcn
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 */
	public Patient getPatientInformation(String transactionId, String siteNumber, String patientIcn)
	throws AwivMethodException, AwivConnectionException;
	
	/**
	 * Get the sensitivity level of the specified patient
	 * @param transactionId
	 * @param siteNumber
	 * @param patientIcn
	 * @return
	 * @throws AwivMethodException
	 * @throws AwivConnectionException
	 */
	public AwivPatientSensitivity getPatientSensitivity(String transactionId, String siteNumber, String patientIcn)
	throws AwivMethodException, AwivConnectionException;
	
	/**
	 * Log access to sensitive patients
	 * 
	 */
	public boolean logPatientSensitiveAccess(String transactionId, String siteNumber, String patientIcn)
	throws AwivMethodException, AwivConnectionException;
	
	public AwivMeansTestResult getPatientMeansTest(String transactionId, String siteNumber, String patientIcn)
	throws AwivMethodException, AwivConnectionException;
}
