/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 4, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.io.Serializable;
import java.util.Date;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author       DNS
 *
 */
public class Patient
implements Serializable, IsSerializable
{

	private static final long serialVersionUID = 6100706032152062277L;
	
	private final static String dateFormat = "MM/dd/yyyy";
	
	private String name;	
	private String icn;
	private String ssn;
	private String veteranStatus;
	private Date dob;
	private boolean sensitive;
	private int agreedSensitiveCode = 0;
	
	public Patient()
	{
		super();
	}
	
	public Patient(String name, String icn, String ssn, String veteranStatus,
			Date dob, boolean sensitive)
	{
		super();
		this.name = name;
		this.icn = icn;
		this.ssn = ssn;
		this.veteranStatus = veteranStatus;
		this.dob = dob;
		this.sensitive = sensitive;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setName(String name)
	{
		this.name = name;
	}
	
	public String getIcn()
	{
		return icn;
	}
	
	public void setIcn(String icn)
	{
		this.icn = icn;
	}
	
	public String getSsn()
	{
		return ssn;
	}
	
	public void setSsn(String ssn)
	{
		this.ssn = ssn;
	}
	
	public String getVeteranStatus()
	{
		return veteranStatus;
	}
	
	public void setVeteranStatus(String veteranStatus)
	{
		this.veteranStatus = veteranStatus;
	}
	
	public Date getDob()
	{
		return dob;
	}
	
	public String getDobFormatted()
	{
		DateTimeFormat dtf = DateTimeFormat.getFormat(dateFormat);
		return dtf.format(this.dob);
	}
	
	public void setDob(Date dob)
	{
		this.dob = dob;
	}

	/**
	 * @return the sensitive
	 */
	public boolean isSensitive()
	{
		return sensitive;
	}

	/**
	 * @param sensitive the sensitive to set
	 */
	public void setSensitive(boolean sensitive)
	{
		this.sensitive = sensitive;
	}

	/**
	 * @return the agreedSensitiveCode
	 */
	public int getAgreedSensitiveCode()
	{
		return agreedSensitiveCode;
	}

	/**
	 * @param agreedSensitiveCode the agreedSensitiveCode to set
	 */
	public void setAgreedSensitiveCode(int agreedSensitiveCode)
	{
		this.agreedSensitiveCode = agreedSensitiveCode;
	}
	
	public void updateAgreedSensitiveCode(int newCode)
	{
		if(newCode > agreedSensitiveCode)
			agreedSensitiveCode = newCode;
	}
}
