/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 3, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants;

import java.io.Serializable;

/**
 * @author       DNS
 *
 */
public class AwivUserInformation
implements Serializable
{
	private static final long serialVersionUID = -5962982452851138637L;
	
	private String duz;
	private String name;
	private String ssn;
	private String siteName;
	private String siteNumber;
	private String brokerSecurityToken;
	private String [] keys;
	private AwivSite patientLookupSite = null;
	private AwivServerInformation awivServerInformation;
	
	public AwivUserInformation()
	{
		super();
	}

	public AwivUserInformation(String duz, String name, String ssn,
			String siteName, String siteNumber, String brokerSecurityToken, 
			String [] keys, AwivServerInformation awivServerInformation)
	{
		super();
		this.duz = duz;
		this.name = name;
		this.ssn = ssn;
		this.siteName = siteName;
		this.siteNumber = siteNumber;
		this.brokerSecurityToken = brokerSecurityToken;
		this.keys = keys;
		this.awivServerInformation = awivServerInformation;
	}

	public String getDuz()
	{
		return duz;
	}

	public void setDuz(String duz)
	{
		this.duz = duz;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getSsn()
	{
		return ssn;
	}

	public void setSsn(String ssn)
	{
		this.ssn = ssn;
	}

	public String getSiteName()
	{
		return siteName;
	}

	public void setSiteName(String siteName)
	{
		this.siteName = siteName;
	}

	public String getSiteNumber()
	{
		return siteNumber;
	}

	public void setSiteNumber(String siteNumber)
	{
		this.siteNumber = siteNumber;
	}

	public String getBrokerSecurityToken()
	{
		return brokerSecurityToken;
	}

	public void setBrokerSecurityToken(String brokerSecurityToken)
	{
		this.brokerSecurityToken = brokerSecurityToken;
	}

	public String[] getKeys()
	{
		return keys;
	}

	public void setKeys(String[] keys)
	{
		this.keys = keys;
	}
	
	public boolean userHasKey(String key)
	{
		for(String k : keys)
		{
			if(key.equals(k))
				return true;
		}
		return false;
	}
	
	public boolean userHasNecessaryKeys()
	{
		if(userHasKey(AwivConstants.magDispClinSecurityKey) || 
				userHasKey(AwivConstants.magDispAdminSecurityKey) || 
				userHasKey(AwivConstants.magPatPhotoOnlySecurityKey))
			return true;
		return false;
	}
	
	public boolean isClaimsAuthentication()
	{
		return AwivConstants.claimsServerSiteNumber.equalsIgnoreCase(this.siteNumber);
	}

	/**
	 * @return the patientLookupSite
	 */
	public String getPatientLookupSiteNumber()
	{
		if(patientLookupSite == null) 
			return siteNumber;
		return patientLookupSite.getSiteNumber();
	}

	/**
	 * @return the patientLookupSite
	 */
	public AwivSite getPatientLookupSite()
	{
		return patientLookupSite;
	}

	/**
	 * @param patientLookupSite the patientLookupSite to set
	 */
	public void setPatientLookupSite(AwivSite patientLookupSite)
	{
		this.patientLookupSite = patientLookupSite;
	}

	/**
	 * @return the awivServerInformation
	 */
	public AwivServerInformation getAwivServerInformation()
	{
		return awivServerInformation;
	}

	/**
	 * @param awivServerInformation the awivServerInformation to set
	 */
	public void setAwivServerInformation(AwivServerInformation awivServerInformation)
	{
		this.awivServerInformation = awivServerInformation;
	}	
	
	/**
	 * Returns true if the user has the MAG SYSTEM key
	 * @return
	 */
	public boolean isImagingSystemUser()
	{
		return userHasKey(AwivConstants.magSystemSecurityKey);
	}
}
