/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 10, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.util.logging.Logger;

import gov.va.med.imaging.awiv.client.events.AwivTimerRunEvent;

import com.google.gwt.user.client.Timer;
/**
 * This is an extension of the GWT Timer.  For some reason the GWT timer doesn't seem to always respect the
 * cancel method - the run event still fires even after cancel has been called.  This extension sets a variable
 * when the cancel method is called and checks to see if canceled was called before calling the run method.
 * 
 * @author       DNS
 *
 */
public class AwivTimer
extends Timer
{
	private final AwivTimerRunEvent timerRunEvent;
	private boolean cancelled;
	private static Logger logger = Logger.getLogger("");
	private final int timerId;
	
	private static int maxTimerId = 0;
	
	public AwivTimer(AwivTimerRunEvent timerRunEvent)
	{
		maxTimerId++;
		timerId = maxTimerId;
		this.timerRunEvent = timerRunEvent;
		cancelled = false;
		logger.info("Created timer '" + timerId + "'.");
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.Timer#run()
	 */
	@Override
	public void run()
	{
		logger.info("Run called in timer '" + timerId + "'.");
		if(!cancelled)
		{
			//Window.alert("About to do run");
			if(timerRunEvent != null)
			{
				logger.info("Timer '" + timerId + "' not cancelled and has timerRunEvent, calling event");
				timerRunEvent.OnTimerRun();
			}
		}
		else
		{
			logger.info("Run cancelled on timer '" + timerId + "'.");
		}
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.Timer#cancel()
	 */
	@Override
	public void cancel()
	{
		//logger.info("Cancel called on timer '" + timerId + "'.");
		super.cancel();
		cancelled = true;
		logger.info("Cancelling timer '" + timerId + "'.");
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.Timer#schedule(int)
	 */
	@Override
	public void schedule(int delayMillis)
	{
		super.schedule(delayMillis);
		cancelled = false;
		logger.info("Scheduling timer '" + timerId + "' for '" + delayMillis + "' ms.");
		//logger.info("schedule(" + delayMillis + ") called on timer '" + timerId + "', resetting cancelled to false");
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.Timer#scheduleRepeating(int)
	 */
	@Override
	public void scheduleRepeating(int periodMillis)
	{
		super.scheduleRepeating(periodMillis);
		cancelled = false;
		logger.info("Schedule repeating timer '" + timerId + "' for '" + periodMillis + "' ms.");
		//logger.info("scheduleRepeating(" + periodMillis + ") called on timer '" + timerId + "', resetting cancelled to false");
	}
	

}
