/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 12, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.io.Serializable;
import java.util.Date;

/**
 * @author       DNS
 *
 */
public class AwivStudy
implements Serializable
{
	private static final long serialVersionUID = -1313273963350789103L;
	
	private String studyIdentifier;
	private String siteNumber;
	private String patientIcn;
	private String patientName;
	private String procedureName;
	private Date procedureDate;
	private String siteAbbr;
	private int imageCount;
	private String shortDescription;
	private String studyPackage;
	private String studyClass;
	private String studyType;
	private String studySpecialty;
	private String firstImageIdentifier;
	private boolean dodArtifact;
	private boolean hasAnnotations;
	private AwivStudyStatus studyViewStatus;
	private boolean sensitive;
	private AwivImage firstImage;
	
	public AwivStudy()
	{
		super();
	}

	public AwivStudy(String studyIdentifier, String siteNumber, String patientIcn, 
			String patientName, String procedureName,
			Date procedureDate, String siteAbbr, int imageCount,
			String shortDescription, String studyPackage, String studyClass,
			String studyType, String studySpecialty, String firstImageIdentifier,
			boolean dodArtifact, boolean hasAnnotations, AwivStudyStatus studyViewStatus,
			boolean sensitive, AwivImage firstImage)
	{
		super();
		this.siteNumber = siteNumber;
		this.studyIdentifier = studyIdentifier;
		this.patientIcn = patientIcn;
		this.patientName = patientName;
		this.procedureName = procedureName;
		this.procedureDate = procedureDate;
		this.siteAbbr = siteAbbr;
		this.imageCount = imageCount;
		this.shortDescription = shortDescription;
		this.studyPackage = studyPackage;
		this.studyClass = studyClass;
		this.studyType = studyType;
		this.studySpecialty = studySpecialty;
		this.firstImageIdentifier = firstImageIdentifier;
		this.dodArtifact = dodArtifact;
		this.hasAnnotations = hasAnnotations;
		this.studyViewStatus = studyViewStatus;
		this.sensitive = sensitive;
		this.firstImage = firstImage;
	}

	public boolean isSensitive()
	{
		return sensitive;
	}

	public void setSensitive(boolean sensitive)
	{
		this.sensitive = sensitive;
	}

	public String getPatientIcn()
	{
		return patientIcn;
	}

	public void setPatientIcn(String patientIcn)
	{
		this.patientIcn = patientIcn;
	}

	public String getPatientName()
	{
		return patientName;
	}

	public void setPatientName(String patientName)
	{
		this.patientName = patientName;
	}

	public String getSiteNumber()
	{
		return siteNumber;
	}

	public void setSiteNumber(String siteNumber)
	{
		this.siteNumber = siteNumber;
	}

	public String getProcedureName()
	{
		return procedureName;
	}

	public void setProcedureName(String procedureName)
	{
		this.procedureName = procedureName;
	}

	public Date getProcedureDate()
	{
		return procedureDate;
	}

	public void setProcedureDate(Date procedureDate)
	{
		this.procedureDate = procedureDate;
	}

	public String getStudyIdentifier()
	{
		return studyIdentifier;
	}

	public void setStudyIdentifier(String studyIdentifier)
	{
		this.studyIdentifier = studyIdentifier;
	}

	public String getSiteAbbr()
	{
		return siteAbbr;
	}

	public void setSiteAbbr(String siteAbbr)
	{
		this.siteAbbr = siteAbbr;
	}

	public int getImageCount()
	{
		return imageCount;
	}

	public void setImageCount(int imageCount)
	{
		this.imageCount = imageCount;
	}

	public String getShortDescription()
	{
		return shortDescription;
	}

	public void setShortDescription(String shortDescription)
	{
		this.shortDescription = shortDescription;
	}

	public String getStudyPackage()
	{
		return studyPackage;
	}

	public void setStudyPackage(String studyPackage)
	{
		this.studyPackage = studyPackage;
	}

	public String getStudyClass()
	{
		return studyClass;
	}

	public void setStudyClass(String studyClass)
	{
		this.studyClass = studyClass;
	}

	public String getStudyType()
	{
		return studyType;
	}

	public void setStudyType(String studyType)
	{
		this.studyType = studyType;
	}

	public String getStudySpecialty()
	{
		return studySpecialty;
	}

	public void setStudySpecialty(String studySpecialty)
	{
		this.studySpecialty = studySpecialty;
	}

	public String getFirstImageIdentifier()
	{
		return firstImageIdentifier;
	}

	public void setFirstImageIdentifier(String firstImageIdentifier)
	{
		this.firstImageIdentifier = firstImageIdentifier;
	}

	/**
	 * @return the dodArtifact
	 */
	public boolean isDodArtifact()
	{
		return dodArtifact;
	}

	/**
	 * @param dodArtifact the dodArtifact to set
	 */
	public void setDodArtifact(boolean dodArtifact)
	{
		this.dodArtifact = dodArtifact;
	}

	/**
	 * @return the hasAnnotations
	 */
	public boolean isHasAnnotations()
	{
		return hasAnnotations;
	}

	/**
	 * @param hasAnnotations the hasAnnotations to set
	 */
	public void setHasAnnotations(boolean hasAnnotations)
	{
		this.hasAnnotations = hasAnnotations;
	}
	
	public AwivStudyStatus getStudyViewStatus()
	{
		return studyViewStatus;
	}

	public void setStudyViewStatus(AwivStudyStatus studyViewStatus)
	{
		this.studyViewStatus = studyViewStatus;
	}

	public boolean isStudyViewable()
	{
		if(studyViewStatus != null)
		{
			return (studyViewStatus.getStudyStatus() < 10);
		}
		return true;
	}

	public AwivImage getFirstImage()
	{
		return firstImage;
	}

	public void setFirstImage(AwivImage firstImage)
	{
		this.firstImage = firstImage;
	}
}
