/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 14, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:      DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.io.Serializable;

/**
 * @author     DNS
 *
 */
public class AwivServerInformation
implements Serializable
{
	private static final long serialVersionUID = -2540888169814640451L;
	
	private String serverVersion;
	private int idleTimeoutMinutes;
	private boolean ieOnly;
	private boolean checkMeansTest;
	
	public AwivServerInformation()
	{
		super();
	}

	/**
	 * @param serverVersion
	 * @param idleTimeoutMinutes
	 */
	public AwivServerInformation(String serverVersion, int idleTimeoutMinutes, boolean ieOnly,
			boolean checkMeansTest)
	{
		this();
		this.serverVersion = serverVersion;
		this.idleTimeoutMinutes = idleTimeoutMinutes;
		this.ieOnly = ieOnly;
		this.checkMeansTest = checkMeansTest;
	}

	/**
	 * @return the serverVersion
	 */
	public String getServerVersion()
	{
		return serverVersion;
	}

	/**
	 * @param serverVersion the serverVersion to set
	 */
	public void setServerVersion(String serverVersion)
	{
		this.serverVersion = serverVersion;
	}

	/**
	 * @return the idleTimeoutMinutes
	 */
	public int getIdleTimeoutMinutes()
	{
		return idleTimeoutMinutes;
	}

	/**
	 * @param idleTimeoutMinutes the idleTimeoutMinutes to set
	 */
	public void setIdleTimeoutMinutes(int idleTimeoutMinutes)
	{
		this.idleTimeoutMinutes = idleTimeoutMinutes;
	}

	/**
	 * @return the ieOnly
	 */
	public boolean isIeOnly()
	{
		return ieOnly;
	}

	/**
	 * @param ieOnly the ieOnly to set
	 */
	public void setIeOnly(boolean ieOnly)
	{
		this.ieOnly = ieOnly;
	}

	/**
	 * @return the checkMeansTest
	 */
	public boolean isCheckMeansTest()
	{
		return checkMeansTest;
	}

	/**
	 * @param checkMeansTest the checkMeansTest to set
	 */
	public void setCheckMeansTest(boolean checkMeansTest)
	{
		this.checkMeansTest = checkMeansTest;
	}

}
