/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 28, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.io.Serializable;

/**
 * This object contains information used during user authentication. This includes the sites the user can authenticate against and the server 
 * configuration information
 * 
 * @author       DNS
 *
 */
public class AwivAuthenticationSitesInformation
implements Serializable
{
	private static final long serialVersionUID = -1456637025963719034L;
	
	private AwivSite [] awivSites;
	private AwivServerInformation awivServerInformation;
	
	public AwivAuthenticationSitesInformation()
	{
		super();
	}

	/**
	 * @param awivSite
	 * @param awivServerInformation
	 */
	public AwivAuthenticationSitesInformation(AwivSite[] awivSites,
			AwivServerInformation awivServerInformation)
	{
		super();
		this.awivSites = awivSites;
		this.awivServerInformation = awivServerInformation;
	}	

	/**
	 * @return the awivSites
	 */
	public AwivSite[] getAwivSites()
	{
		return awivSites;
	}

	/**
	 * @param awivSites the awivSites to set
	 */
	public void setAwivSites(AwivSite[] awivSites)
	{
		this.awivSites = awivSites;
	}

	/**
	 * @return the awivServerInformation
	 */
	public AwivServerInformation getAwivServerInformation()
	{
		return awivServerInformation;
	}

	/**
	 * @param awivServerInformation the awivServerInformation to set
	 */
	public void setAwivServerInformation(AwivServerInformation awivServerInformation)
	{
		this.awivServerInformation = awivServerInformation;
	}

}
