/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 16, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.business;

import java.io.Serializable;

/**
 * @author       DNS
 *
 */
public class AwivArtifactResults
implements Serializable
{
	private static final long serialVersionUID = 7917191444356257455L;
	
	private AwivStudy [] awivStudies = null;
	private boolean partialResult = false;
	private String partialResultMessage = null;
	
	public AwivArtifactResults()
	{
		super();
	}

	/**
	 * @param awivStudies
	 * @param partialResult
	 * @param partialResultMessage
	 */
	public AwivArtifactResults(AwivStudy[] awivStudies, boolean partialResult,
			String partialResultMessage)
	{
		super();
		this.awivStudies = awivStudies;
		this.partialResult = partialResult;
		this.partialResultMessage = partialResultMessage;
	}

	/**
	 * @return the awivStudies
	 */
	public AwivStudy[] getAwivStudies()
	{
		return awivStudies;
	}

	/**
	 * @param awivStudies the awivStudies to set
	 */
	public void setAwivStudies(AwivStudy[] awivStudies)
	{
		this.awivStudies = awivStudies;
	}

	/**
	 * @return the partialResult
	 */
	public boolean isPartialResult()
	{
		return partialResult;
	}

	/**
	 * @param partialResult the partialResult to set
	 */
	public void setPartialResult(boolean partialResult)
	{
		this.partialResult = partialResult;
	}

	/**
	 * @return the partialResultMessage
	 */
	public String getPartialResultMessage()
	{
		return partialResultMessage;
	}

	/**
	 * @param partialResultMessage the partialResultMessage to set
	 */
	public void setPartialResultMessage(String partialResultMessage)
	{
		this.partialResultMessage = partialResultMessage;
	}	
	
	public int size()
	{
		return (awivStudies == null ? 0 : awivStudies.length);
	}
}
