/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.awiv;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class AWIVClientRouterTest
 //extends  gov.va.med.imaging.ImagingBaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public AWIVClientRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCachedWelcomeMessage(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCachedWelcomeMessageCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WelcomeMessage.class, 
	 				"GetCachedWelcomeMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCachedWelcomeMessageCommand' in method 'getCachedWelcomeMessage' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserKeysCommand(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserKeysCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetUserKeysCommand' in method 'getUserKeysCommand' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowArtifactResultsForPatientFromSiteWithCaching(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand' in method 'getShallowArtifactResultsForPatientFromSiteWithCaching' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientInformation(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientInformationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientInformationCommand' in method 'getPatientInformation' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientSensitivityLevel(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientSensitivityLevelCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientSensitiveValue.class, 
	 				"GetPatientSensitivityLevelCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientSensitivityLevelCommand' in method 'getPatientSensitivityLevel' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postSensitivePatientAccess(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostSensitivePatientAccessCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostSensitivePatientAccessCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostSensitivePatientAccessCommand' in method 'postSensitivePatientAccess' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void authenticateUser(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserAuthenticationCommand' and parameters 'gov.va.med.RoutingToken'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetUserAuthenticationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetUserAuthenticationCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientMeansTest(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientMeansTestCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientMeansTestResult.class, 
	 				"GetPatientMeansTestCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientMeansTestCommand' in method 'getPatientMeansTest' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 }