/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands.v2;

import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.awiv.translator.AWIVTranslatorV2;
import gov.va.med.imaging.awiv.webservices.commands.AbstractAwivPostThinClientAccessEventCommand;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImagingLogEvent;

/**
 * @author       DNS
 *
 */
public class AwivPostThinClientAccessEventCommandV2
extends AbstractAwivPostThinClientAccessEventCommand
{
	private final String transactionId;
	private final gov.va.med.imaging.awiv.webservices.soap.v2.ThinClientAccessLogEventType thinClientDetails;

	/**
	 * @param imagingLogEvent
	 */
	public AwivPostThinClientAccessEventCommandV2(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.ThinClientAccessLogEventType thinClientDetails)
	{
		super();
		AwivCommandCommonV2.setTransactionContext(thinClientDetails.getCredentials(), transactionId);
		this.thinClientDetails = thinClientDetails;
		this.transactionId = transactionId;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getInterfaceVersion()
	 */
	@Override
	public String getInterfaceVersion()
	{
		return AwivCommandCommonV2.awivV2InterfaceVersion;
	}

	@Override
	protected ImagingLogEvent getImagingLogEvent()
	{
		try
		{
			return AWIVTranslatorV2.translate(thinClientDetails, transactionId);
		} 
		catch (URNFormatException e)
		{
			getLogger().error("Error translating ImagingLogEvent, " + e.getMessage());
			return null;
		} 
		catch (RoutingTokenFormatException e)
		{
			getLogger().error("Error translating ImagingLogEvent, " + e.getMessage());
			return null;
		}
	}

}
