/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 15, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands.v2;

import gov.va.med.imaging.awiv.translator.AWIVTranslatorV2;
import gov.va.med.imaging.awiv.webservices.commands.AbstractAwivPostImageAccessEventCommand;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;

/**
 * @author      DNS
 *
 */
public class AwivPostImageAccessEventCommandV2
extends AbstractAwivPostImageAccessEventCommand
{
	private ImageAccessLogEvent imageAccessLogEvent = null;
	private boolean logEventTranslated = false;
	private final gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventType logEvent;
	
	public AwivPostImageAccessEventCommandV2(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventType logEvent)
	{
		super();
		AwivCommandCommonV2.setTransactionContext(logEvent.getCredentials(), transactionId);
		this.logEvent = logEvent;
	}

	@Override
	protected ImageAccessLogEvent getImageAccessLogEvent()
	throws URNFormatException
	{
		// the translator might not be able to translate the event, if it can't then the result
		// is still null but we don't want to bother trying over and over again
		// so use logEventTranslated boolean to keep track of that and only try it once
		if((imageAccessLogEvent == null) && (!logEventTranslated))
		{
			imageAccessLogEvent = AWIVTranslatorV2.translate(logEvent);
			logEventTranslated = true;
		}
		return imageAccessLogEvent;
	}

	@Override
	public String getInterfaceVersion()
	{
		return AwivCommandCommonV2.awivV2InterfaceVersion;
	}

}
