/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 15, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:       DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands.v2;

import gov.va.med.imaging.awiv.translator.AWIVTranslatorV2;
import gov.va.med.imaging.awiv.webservices.commands.AbstractAwivPingServerCommand;
import gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;

/**
 * @author       DNS
 *
 */
public class AwivPingServerCommandV2
extends AbstractAwivPingServerCommand<gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse>
{
	
	public AwivPingServerCommandV2(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String workstation,
			String requestSiteNumber)
	{
		super(workstation, requestSiteNumber);
		AwivCommandCommonV2.setTransactionContext(userCredentials, transactionId);		
	}

	@Override
	protected gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse translateRouterResult(
			SiteConnectivityStatus routerResult) 
	throws TranslationException, MethodException
	{
		return AWIVTranslatorV2.translate(routerResult);
	}

	@Override
	protected Class<gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse> getResultClass()
	{
		return gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse.class;
	}

	@Override
	public String getInterfaceVersion()
	{
		return AwivCommandCommonV2.awivV2InterfaceVersion;
	}

	@Override
	public Integer getEntriesReturned(
			PingServerTypePingResponse translatedResult)
	{
		return null;
	}

}
