/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 7, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands.v2;

import java.util.List;

import gov.va.med.imaging.awiv.translator.AWIVTranslatorV2;
import gov.va.med.imaging.awiv.webservices.commands.AbstractAwivGetImageAccessReasonsCommand;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.ImageAccessReason;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.exchange.enums.ImageAccessReasonType;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;

/**
 * @author       DNS
 *
 */
public class AwivGetImageAccessReasonsCommandV2
extends AbstractAwivGetImageAccessReasonsCommand<gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[]>
{
	private final gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] reasonTypes;

	/**
	 * @param siteId
	 */
	public AwivGetImageAccessReasonsCommandV2(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials,
			String siteId, 
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] reasonTypes)
	{
		super(getProperSiteId(userCredentials, siteId));
		this.reasonTypes = reasonTypes;
		AwivCommandCommonV2.setTransactionContext(userCredentials, transactionId);		
	}
	
	private static String getProperSiteId(gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String siteId)
	{
		if(ExchangeUtil.isSiteDOD(siteId))
		{
			// cannot get reasons from the DoD so get from the patient lookup site if available or the user authentication site
			String patientLookupSiteNumber = userCredentials.getPatientLookupSite();
			if(patientLookupSiteNumber != null && patientLookupSiteNumber.length() > 0)
				return patientLookupSiteNumber;
			return userCredentials.getSiteNumber();
		}
		return siteId;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.commands.AbstractAwivGetImageAccessReasonsCommand#getReasonTypes()
	 */
	@Override
	protected List<ImageAccessReasonType> getReasonTypes()
	{
		return AWIVTranslatorV2.translate(reasonTypes);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[] translateRouterResult(
			List<ImageAccessReason> routerResult) 
	throws TranslationException, MethodException
	{
		return AWIVTranslatorV2.translateImageAccessReasons(routerResult);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[]> getResultClass()
	{
		return gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[].class;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getInterfaceVersion()
	 */
	@Override
	public String getInterfaceVersion()
	{
		return AwivCommandCommonV2.awivV2InterfaceVersion;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[] translatedResult)
	{
		return translatedResult == null ? 0 : translatedResult.length;
	}

}
