/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 10, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands.v2;

import gov.va.med.imaging.awiv.translator.AWIVTranslatorV2;
import gov.va.med.imaging.awiv.webservices.commands.AbstractAwivGetElectronicSignatureCommand;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.ElectronicSignatureResult;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;

/**
 * @author      DNS
 *
 */
public class AwivGetElectronicSignatureCommandV2
extends AbstractAwivGetElectronicSignatureCommand<gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType>
{

	/**
	 * @param siteId
	 * @param electronicSignature
	 */
	public AwivGetElectronicSignatureCommandV2(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials,			
			String electronicSignature)
	{
		super(userCredentials.getSiteNumber(), electronicSignature);
		AwivCommandCommonV2.setTransactionContext(userCredentials, transactionId);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType translateRouterResult(
			ElectronicSignatureResult routerResult)
	throws TranslationException, MethodException
	{
		return AWIVTranslatorV2.translate(routerResult);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType> getResultClass()
	{
		return gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType.class;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getInterfaceVersion()
	 */
	@Override
	public String getInterfaceVersion()
	{
		return AwivCommandCommonV2.awivV2InterfaceVersion;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(
			gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType translatedResult)
	{
		return null;
	}

}
