/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands;

import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.awiv.AWIVRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.ImagingLogEvent;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.HashMap;
import java.util.Map;

/**
 * @author       DNS
 *
 */
public abstract class AbstractAwivPostThinClientAccessEventCommand
extends AbstractAwivWebserviceCommand<Boolean, Boolean>
{
	/**
	 * @param methodName
	 */
	public AbstractAwivPostThinClientAccessEventCommand()
	{
		super("postThinClientAccessEvent");
	}
	
	protected abstract ImagingLogEvent getImagingLogEvent();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#executeRouterCommand()
	 */
	@Override
	protected Boolean executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		AWIVRouter rtr = getRouter(); 
		
			rtr.postImagingLogEvent(getImagingLogEvent());
			
			return true;
			/*
			ImageAccessLogEvent logEvent = getImageAccessLogEvent();
			if(logEvent == null)
			{
				getLogger().warn("ImageAccessLogEvent is null, cannot log entry, returning false.");
				return false;
			}
			else
			{
				
				rtr.logImageAccessEvent(logEvent);
				return true;
			}*/
		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getMethodParameterValuesString()
	 */
	@Override
	protected String getMethodParameterValuesString()
	{
		ImagingLogEvent imagingLogEvent = getImagingLogEvent();
		return imagingLogEvent.getAccessType() + " from application '" + imagingLogEvent.getUserInterface() + "'.";
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected Boolean translateRouterResult(Boolean routerResult)
	throws TranslationException, MethodException
	{
		return routerResult;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<Boolean> getResultClass()
	{
		return Boolean.class;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getTransactionContextFields()
	 */
	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);
		
		ImagingLogEvent imagingLogEvent = getImagingLogEvent();
		AbstractImagingURN imagingUrn = imagingLogEvent.getImagingUrn();
		if(imagingUrn != null)
		{
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, imagingUrn.getPatientId());
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, imagingUrn.toString());
		}
		else if(imagingLogEvent.getPatientIcn() != null)
		{
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, imagingLogEvent.getPatientIcn());
		}

		return transactionContextFields;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(Boolean translatedResult)
	{
		return null;
	}
}
