/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 16, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands;

import java.util.HashMap;
import java.util.Map;

import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.awiv.AWIVRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

/**
 * @author       DNS
 *
 */
public abstract class AbstractAwivGetStudyCommand<E extends Object>
extends AbstractAwivWebserviceCommand<Study, E>
{
	private final String studyUrnAsString;
	
	public AbstractAwivGetStudyCommand(String studyUrnAsString)
	{
		super("getStudy");
		this.studyUrnAsString = studyUrnAsString;
	}

	@Override
	protected Study executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		StudyURN studyUrn = null;
		try
		{
			studyUrn = URNFactory.create(studyUrnAsString, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
		}
		catch (URNFormatException urnfX)
		{
			throw new MethodException("URNFormatException, unable to get study by study URN", urnfX);
		}
		getTransactionContext().setPatientID(studyUrn.getPatientId());
		AWIVRouter router = getRouter();
		return router.getPatientStudy(studyUrn);
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "for study '" + getStudyUrnAsString() + "'.";
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, getStudyUrnAsString());
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);

		return transactionContextFields;
	}

	public String getStudyUrnAsString()
	{
		return studyUrnAsString;
	}

}
