/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 15, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands;

import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.CprsIdentifier;
import gov.va.med.imaging.awiv.AWIVRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author       DNS
 *
 */
public abstract class AbstractAwivGetImageListCommand<E extends Object>
extends AbstractAwivWebserviceCommand<List<Study>, E>
{
	private final String siteId;
	private final String patientIcn;
	private final String cprsIdentifier;	

	public AbstractAwivGetImageListCommand(String siteId,
			String patientIcn, String cprsIdentifier)
	{
		super("getImageList");
		this.siteId = siteId;
		this.patientIcn = patientIcn;
		this.cprsIdentifier = cprsIdentifier;
	}

	@Override
	protected List<Study> executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		AWIVRouter router = getRouter();
		try
		{
			return router.getStudiesByCprsIdentifier(getPatientIcn(), 
					RoutingTokenHelper.createSiteAppropriateRoutingToken(getSiteId()), 
					new CprsIdentifier(getCprsIdentifier()));
		}
		catch (RoutingTokenFormatException rtfX)
		{
			throw new MethodException("RoutingTokenFormatException, unable to get studies by CPRS identifier", rtfX);
		}
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "for CPRS Identifier '" + getCprsIdentifier() + "', from site '" + getSiteId() + "'.";
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, getPatientIcn());
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);

		return transactionContextFields;
	}

	public String getSiteId()
	{
		return siteId;
	}

	public String getPatientIcn()
	{
		return patientIcn;
	}

	public String getCprsIdentifier()
	{
		return cprsIdentifier;
	}

}
