/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 12, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices.commands;

import java.util.HashMap;
import java.util.Map;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.awiv.AWIVRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.DocumentFilter;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

/**
 * @author       DNS
 *
 */
public abstract class AbstractAwivGetDoDArtifactsCommand<E extends Object>
extends AbstractAwivWebserviceCommand<DocumentSetResult, E>
{
	private final String patientIcn;
	
	public AbstractAwivGetDoDArtifactsCommand(String patientIcn)
	{
		super("getArtifacts");
		this.patientIcn = patientIcn;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#executeRouterCommand()
	 */
	@Override
	protected DocumentSetResult executeRouterCommand() 
	throws MethodException, ConnectionException
	{		
		try
		{
			//RoutingTokenImpl.createDoDDocumentSite(ExchangeUtil.getDodSiteNumber());
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(ExchangeUtil.getDodSiteNumber());
			AWIVRouter router = getRouter();
			DocumentFilter documentFilter = new DocumentFilter(getPatientIcn());
			
			// get ArtifactResults command because it handles caching of DocumentSets, will throw away the StudySetResult piece (which should be empty anyway)
			// only trying to get DocumentSets and do want to allow it to be from the cache
			ArtifactResults artifactResults = 
				router.getShallowArtifactResultsForPatientFromSiteWithCaching(routingToken, 
						PatientIdentifier.icnPatientIdentifier(getPatientIcn()),
						documentFilter, false, true, true);
			return artifactResults.getDocumentSetResult();
			//return router.getCachedDocumentSetResultFromSite(routingToken, documentFilter);
		} 
		catch (RoutingTokenFormatException rtfX)
		{
			throw new MethodException("RoutingTokenFormatException, unable to create routing token to access DoD", rtfX);			
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getMethodParameterValuesString()
	 */
	@Override
	protected String getMethodParameterValuesString()
	{
		return "for patient '" + getPatientIcn() + "'.";
	}
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getTransactionContextFields()
	 */
	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, getPatientIcn());

		return transactionContextFields;
	}
	
	/**
	 * @return the patientIcn
	 */
	public String getPatientIcn()
	{
		return patientIcn;
	}
}
