/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 15, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:      DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices;

import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetAnnotationsAvailableCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetDoDArtifactsCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetElectronicSignatureCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetImageAccessReasonsCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetImageAnnotationDetailsCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetImageAnnotationsCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetImageListCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetStudyCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivGetStudyReportCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivPingServerCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivPostImageAccessEventCommandV2;
import gov.va.med.imaging.awiv.webservices.commands.v2.AwivPostThinClientAccessEventCommandV2;
import gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType;
import gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType;

import java.rmi.RemoteException;

/**
 * @author       DNS
 *
 */
public class AWIVWebServices_v2
implements gov.va.med.imaging.awiv.webservices.soap.v2.ImageAWIVMetadata
{

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.GroupType getImageList(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String siteNumber,
			String patientIcn, String cprsIdentifier) 
	throws RemoteException
	{
		return new AwivGetImageListCommandV2(transactionId, userCredentials, 
				siteNumber, patientIcn, cprsIdentifier).executeAwivCommand();
	}

	@Override
	public boolean postImageAccessEvent(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventType logEvent) 
	throws RemoteException
	{
		return new AwivPostImageAccessEventCommandV2(transactionId, 
				logEvent).executeAwivCommand();
	}

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse pingServerEvent(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String workstation,
			String requestSiteNumber) 
	throws RemoteException
	{
		return new AwivPingServerCommandV2(transactionId, userCredentials, 
				workstation, requestSiteNumber).executeAwivCommand();
	}

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.GroupType getStudy(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, 
			String studyUrn)
	throws RemoteException
	{
		return new AwivGetStudyCommandV2(transactionId, userCredentials, studyUrn).executeAwivCommand();
	}

	@Override
	public String getStudyReport(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String studyUrn)
	throws RemoteException
	{
		return new AwivGetStudyReportCommandV2(transactionId, userCredentials, studyUrn).executeAwivCommand();
	}

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType[] getImageAnnotations(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType credentials, String imageId)
	throws RemoteException
	{
		return new AwivGetImageAnnotationsCommandV2(transactionId, credentials, 
				imageId).executeAwivCommand();
	}

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationDetailsType getAnnotationDetails(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType credentials, String imageId, String annotationId)
	throws RemoteException
	{
		return new AwivGetImageAnnotationDetailsCommandV2(transactionId, 
				credentials, imageId, annotationId).executeAwivCommand();
	}

	@Override
	public boolean isAnnotationsSupported(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType credentials, String siteId)
	throws RemoteException
	{
		return new AwivGetAnnotationsAvailableCommandV2(transactionId, credentials, siteId).executeAwivCommand();
	}

	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.GroupType getArtifacts(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials, String patientIcn)
	throws RemoteException
	{
		return new AwivGetDoDArtifactsCommandV2(transactionId, userCredentials, 
				patientIcn).executeAwivCommand();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v2.ImageAWIVMetadata#thinClientAccessEvent(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v2.ThinClientAccessLogEventType)
	 */
	@Override
	public boolean thinClientAccessEvent(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.ThinClientAccessLogEventType thinClientDetails)
	throws RemoteException
	{
		return new AwivPostThinClientAccessEventCommandV2(transactionId, 
				thinClientDetails).executeAwivCommand();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v2.ImageAWIVMetadata#getImageAccessReasons(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType, gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[])
	 */
	@Override
	public gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[] getImageAccessReasons(
			String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType userCredentials,
			String siteId, 
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] reasonTypes) 
	throws RemoteException
	{
		return new AwivGetImageAccessReasonsCommandV2(transactionId, 
				userCredentials, siteId, reasonTypes).executeAwivCommand();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v2.ImageAWIVMetadata#postElectronicSignatureCheck(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v2.UserCredentialsType, java.lang.String)
	 */
	@Override
	public ElectronicSignatureResultType postElectronicSignatureCheck(
			String transactionId, UserCredentialsType userCredentials,
			String electronicSignature) 
	throws RemoteException
	{
		return new AwivGetElectronicSignatureCommandV2(transactionId, 
				userCredentials, electronicSignature).executeAwivCommand();
	}
}
