/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 6, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import gov.va.med.URNFactory;
import gov.va.med.imaging.DocumentURN;
import gov.va.med.imaging.awiv.web.exceptions.AWIVDodRequestQueryException;
import gov.va.med.imaging.exceptions.URNFormatException;

import javax.servlet.http.HttpServletRequest;

/**
 * Servlet for providing access to DoD images.
 * 
 * @author DNS
 * @deprecated This functionality is no longer supported
 *
 */
public class DodImageRequest 
{
	
	public static DodImageRequest parseRequest(HttpServletRequest request)
	throws AWIVDodRequestQueryException
	{
		String documentId = request.getParameter("documentId");
		String homeCommunityId = request.getParameter("homeCommunityId");
		String repositoryId = request.getParameter("repositoryId");
		String siteNumber = request.getParameter("siteNumber");
		String patientIcn = request.getParameter("patientIcn");		
		//siteNumber = "660";
		
		checkValue(documentId, "documentId");
		checkValue(homeCommunityId, "homeCommunityId");
		checkValue(repositoryId, "repositoryId");
		checkValue(siteNumber, "siteNumber");
		checkValue(patientIcn, "patientIcn");
		
		return new DodImageRequest(patientIcn, siteNumber, 
				homeCommunityId, documentId, repositoryId);	
	}
	
	private static void checkValue(String value, String valueName)
	throws AWIVDodRequestQueryException
	{
		String errorMsg = "Required parameter '" + valueName + "' is missing or empty.";
		if(value == null)
			throw new AWIVDodRequestQueryException(errorMsg);
		if(value.length() <= 0)
			throw new AWIVDodRequestQueryException(errorMsg);
	}
	
	private final String patientIcn;
	private final String siteNumber;
	private final String homeCommunityId;
	private final String documentId;
	private final String repositoryId;
	
	public DodImageRequest(String patientIcn, String siteNumber,
			String homeCommunityId, String documentId, String repositoryId) 
	{
		super();
		this.patientIcn = patientIcn;
		this.siteNumber = siteNumber;
		this.homeCommunityId = homeCommunityId;
		this.documentId = documentId;
		this.repositoryId = repositoryId;
	}
	/**
	 * @return the patientIcn
	 */
	public String getPatientIcn() {
		return patientIcn;
	}
	/**
	 * @return the siteNumber
	 */
	public String getSiteNumber() {
		return siteNumber;
	}
	/**
	 * @return the homeCommunityId
	 */
	public String getHomeCommunityId() {
		return homeCommunityId;
	}
	/**
	 * @return the documentId
	 */
	public String getDocumentId() {
		return documentId;
	}
	/**
	 * @return the repositoryId
	 */
	public String getRepositoryId() {
		return repositoryId;
	}
	
	public DocumentURN getDocumentUrn()
	throws URNFormatException
	{
		try
		{
			return URNFactory.create(getDocumentId(), DocumentURN.class);
		}
		catch(URNFormatException urnfX)
		{
			//
		}
		return DocumentURN.create(getSiteNumber(), getDocumentId(), getDocumentId(), getPatientIcn());
	}
}
