/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 6, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import gov.va.med.imaging.DocumentURN;
import gov.va.med.imaging.awiv.web.exceptions.AWIVDodRequestQueryException;
import gov.va.med.imaging.channels.ByteStreamPump;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.wado.AbstractBaseImageServlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author DNS
 * @deprecated This servlet is no longer supported
 *
 */
public class AWVIDodImageAccessServletV1 
extends AbstractBaseImageServlet
{
	private static final long serialVersionUID = -5273197724500506527L;

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBaseImageServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		getLogger().info("Beginning GET handler: servlet path=[" + request.getServletPath() + 
				   "],  path info=[" + request.getPathInfo() +
				   "]\nquery string: [" + request.getQueryString() + "]");	
		DodImageRequest imageRequest = null;
		try
		{
			imageRequest = DodImageRequest.parseRequest(request);
			//getLogger().info("Document ID: " + imageRequest.getDocumentId());
		}
		catch(AWIVDodRequestQueryException dodrqX)
		{
			String msg = "Request is not a valid Dod Image request: " + dodrqX.getMessage();
			getLogger().error(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(dodrqX.getClass().getSimpleName());
			transactionContext.setResponseCode(HttpServletResponse.SC_NOT_ACCEPTABLE + "");
			response.sendError(HttpServletResponse.SC_NOT_ACCEPTABLE, msg );
		}
		
		DocumentURN documentUrn = null;
		try
		{
			documentUrn = imageRequest.getDocumentUrn();			
			initTransactionContext(imageRequest);
		}
		catch(URNFormatException urnfX)
		{
			String msg = "Request is not a valid Dod Image request: " + urnfX.getMessage();
			getLogger().error(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(urnfX.getClass().getSimpleName());
			transactionContext.setResponseCode(HttpServletResponse.SC_NOT_ACCEPTABLE + "");
			response.sendError(HttpServletResponse.SC_NOT_ACCEPTABLE, msg );
		}		

		try
		{
			getLogger().info("Initiating DoD document request using URN '" + documentUrn.toString() + "'");
			DocumentRetrieveResult result = retrieveDocument(documentUrn);
			getLogger().info("Got " + ((result == null) || (result.getDocumentStream() == null) ? "null" : "NOT null") + " document result.");
			
			if((result == null) || (result.getDocumentStream() == null))
			{
				String msg = "Got null document stream response";
				getLogger().error(msg);
				transactionContext.setErrorMessage(msg);
				transactionContext.setResponseCode(HttpServletResponse.SC_INTERNAL_SERVER_ERROR + "");	
				response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, msg );
			}
			else
			{			
				try
				{
					getLogger().info("Pumping document response to output stream");
					long startTime = System.currentTimeMillis();
					ByteStreamPump pump = ByteStreamPump.getByteStreamPump();
					pump.xfer(result.getDocumentStream(), response.getOutputStream());
					getLogger().info("Done pumping document response to output stream, took '" + (System.currentTimeMillis() - startTime) + "' ms.");
				}
				catch(IOException ioX)
				{
					String msg = "Error pumping document response: " + ioX.getMessage();
					getLogger().error(msg);
					transactionContext.setErrorMessage(msg);
					transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
					transactionContext.setResponseCode(HttpServletResponse.SC_INTERNAL_SERVER_ERROR + "");				
					throw ioX;
				}
				finally
				{
					if(result != null)
					{
						if(result.getDocumentStream() != null)
						{
							try
							{
								result.getDocumentStream().close();
							}
							catch(IOException ioX){}
						}
					}
				}
			}
		}
		catch(AbstractBaseImageServlet.ImageServletException isX)
		{
			String msg = isX.getMessage();
			getLogger().error(msg);
			transactionContext.setErrorMessage(msg);
			// don't set the transactionContext.setExceptionClassName() property here
			// it gets set in the AbstractBaseImageServlet because that is where the real
			// exception is caught
			//transactionContext.setExceptionClassName(isX.getClass().getName());
			transactionContext.setResponseCode(isX.getResponseCode() + "");
			response.sendError(isX.getResponseCode(), msg );
		}	
		catch(Exception ex)
		{
			getLogger().error(ex);
			ex.printStackTrace();
			transactionContext.setErrorMessage(ex.getMessage());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			transactionContext.setResponseCode(HttpServletResponse.SC_INTERNAL_SERVER_ERROR + "");
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, ex.getMessage());
		}
	}	

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBaseImageServlet#getUserSiteNumber()
	 */
	@Override
	public String getUserSiteNumber() 
	{
		TransactionContext context = TransactionContextFactory.get();
		return context.getLoggerSiteNumber();
	}
	
	protected void initTransactionContext(DodImageRequest dodImageRequest)
	throws URNFormatException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setQueryFilter("n/a");			
		transactionContext.setQuality("n/a");
		transactionContext.setQueryFilter("n/a");		
		
		String imageUrnAsString = "";
		
		imageUrnAsString = dodImageRequest.getDocumentUrn().toString();// TransactionContextFactory.decodeUrnForLogging(imageURN);//  decodeDodUrnForLogging(imageURN.toString());
		
		transactionContext.setRequestType("AWIV WebApp V1 DOD Document Retrieve");
		
		transactionContext.setPatientID(dodImageRequest.getPatientIcn());
		transactionContext.setUrn(imageUrnAsString);
		transactionContext.setModality("n/a");
	}
}