/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.awiv;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class AWIVRouterTest
 //extends  gov.va.med.imaging.ImagingBaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public AWIVRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudiesByCprsIdentifier(
 			java.lang.String patientIcn
 		 			, gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.CprsIdentifier cprsIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudiesByCprsIdentifierCommand' and parameters 'java.lang.String, gov.va.med.RoutingToken, gov.va.med.imaging.CprsIdentifier'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudiesByCprsIdentifierCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken.class, gov.va.med.imaging.CprsIdentifier.class 
	  			},
				new Object[]{
			 		patientIcn,routingToken,cprsIdentifier
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudiesByCprsIdentifierCommand' in method 'getStudiesByCprsIdentifier' with parameters 'java.lang.String, gov.va.med.RoutingToken, gov.va.med.imaging.CprsIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotations(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationListByImageUrnCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
 				"GetImageAnnotationListByImageUrnCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.AbstractImagingURN.class 
	  			},
				new Object[]{
			 		imagingUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetImageAnnotationListByImageUrnCommand' in method 'getImageAnnotations' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, gov.va.med.imaging.ImageAnnotationURN imageAnnotationUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, gov.va.med.imaging.ImageAnnotationURN.class 
		  			},
 					new Object[]{
				 		imagingUrn,imageAnnotationUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageAnnotationDetailsCommand' in method 'getImageAnnotationDetails' with parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void isSiteAnnotationSupported(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetSiteAnnotationSupportedStatusCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"GetSiteAnnotationSupportedStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetSiteAnnotationSupportedStatusCommand' in method 'isSiteAnnotationSupported' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetResultBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentSetResultBySiteNumberCommand' in method 'getDocumentSetResultBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowArtifactResultsForPatientFromSiteWithCaching(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 			, boolean canGetFromCache
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments,canGetFromCache
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand' in method 'getShallowArtifactResultsForPatientFromSiteWithCaching' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEvent(
 			gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImagingLogEventCommand' and parameters 'gov.va.med.imaging.exchange.ImagingLogEvent'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostImagingLogEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  			},
 					new Object[]{
				 		imagingLogEvent
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImagingLogEventCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAccessReasons(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<gov.va.med.imaging.exchange.enums.ImageAccessReasonType> reasonTypes
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAccessReasonListCommand' and parameters 'gov.va.med.RoutingToken, java.util.List'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.ImageAccessReason.class, 
 				"GetImageAccessReasonListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.util.List.class 
	  			},
				new Object[]{
			 		routingToken,reasonTypes
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetImageAccessReasonListCommand' in method 'getImageAccessReasons' with parameters 'gov.va.med.RoutingToken, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void verifyElectronicSignature(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String electronicSignature
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVerifyElectronicSignatureCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ElectronicSignatureResult.class, 
	 				"GetVerifyElectronicSignatureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,electronicSignature
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVerifyElectronicSignatureCommand' in method 'verifyElectronicSignature' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 }