/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.awiv;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class AWIVRouterImpl
 extends  gov.va.med.imaging.ImagingBaseWebFacadeRouterImpl 
 implements AWIVRouter
 {
	private static AWIVRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized AWIVRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new AWIVRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected AWIVRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getStudiesByCprsIdentifier(
 			java.lang.String patientIcn
 		 			, gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.CprsIdentifier cprsIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudiesByCprsIdentifierCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken.class, gov.va.med.imaging.CprsIdentifier.class 
	  			},
				new Object[]{
			 		patientIcn,routingToken,cprsIdentifier
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStudiesByCprsIdentifierCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.annotations.ImageAnnotation> getImageAnnotations(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
 				"GetImageAnnotationListByImageUrnCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.AbstractImagingURN.class 
	  			},
				new Object[]{
			 		imagingUrn
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetImageAnnotationListByImageUrnCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.annotations.ImageAnnotation> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails getImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, gov.va.med.imaging.ImageAnnotationURN imageAnnotationUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails> command = (Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, gov.va.med.imaging.ImageAnnotationURN.class 
		  			},
 					new Object[]{
				 		imagingUrn,imageAnnotationUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageAnnotationDetailsCommand");
		
      
        gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean isSiteAnnotationSupported(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"GetSiteAnnotationSupportedStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetSiteAnnotationSupportedStatusCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentSetResult getDocumentSetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentSetResultBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentSetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getShallowArtifactResultsForPatientFromSiteWithCaching(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 			, boolean canGetFromCache
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments,canGetFromCache
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyOnlyArtifactResultsBySiteNumberWithCachingCommand");
		
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEvent(
 			gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostImagingLogEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  			},
 					new Object[]{
				 		imagingLogEvent
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImagingLogEventCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.ImageAccessReason> getImageAccessReasons(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<gov.va.med.imaging.exchange.enums.ImageAccessReasonType> reasonTypes
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.ImageAccessReason.class, 
 				"GetImageAccessReasonListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.util.List.class 
	  			},
				new Object[]{
			 		routingToken,reasonTypes
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetImageAccessReasonListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.ImageAccessReason> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ElectronicSignatureResult verifyElectronicSignature(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String electronicSignature
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ElectronicSignatureResult> command = (Command<gov.va.med.imaging.exchange.business.ElectronicSignatureResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ElectronicSignatureResult.class, 
	 				"GetVerifyElectronicSignatureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,electronicSignature
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetVerifyElectronicSignatureCommand");
		
      
        gov.va.med.imaging.exchange.business.ElectronicSignatureResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }