/* Set values for gallery auto-rotation */
var iCurrent=1; // Sets the first gallery image
var timer;  // Variable for timer
var iSeconds = 10; // Number of seconds between rotations
var iMax; // Creates variable for the number of gallery images

/* Set inital promo and nav icon on page load */
var currentSlide = "div#slide"+iCurrent;
var currentNav = "a#slideNav"+iCurrent;

$(document).ready(function(){
	var btnTitle = ["","First","Second","Third","Fourth","Fifth","Sixth","Seventh","Eighth","Ninth","Tenth"];

	iMax = $("#slideshow-wrapper > .slide").size();

	/*Dynamically Add Nav Buttons*/
	if (iMax > 1) {
		var slideNav = '<div id="slideNavBar">' +	'<ul>';
		for (i=1; i<=iMax; i++) {
			slideNav += '<li><a id="slideNav' + i + '" class="slideNav" href="#slide' + i + '" title="' + btnTitle[i] + ' slideshow item">' + i + '</a></li>';
		}
		slideNav += '</ul>' + '</div>';
		
		$("#slide" + iMax).after(slideNav);
	}


	/* Set initial gallery nav state */
	$(currentNav).addClass("selected");
	
	/* Start timer */
	timer = setInterval("ChangeSlide($(currentNav), $('a#slideNav'+getNextID()))", (iSeconds*1000));
	
	/* add click event function to switch promos */
	$("div#slideNavBar a.slideNav").click(function () {
		ChangeSlide($(currentNav), $(this));
		return false;
	});


});
		
/* Function to switch promos and restart timer */
function ChangeSlide(oCurrent, oNew) {
	// If the user clicks on a different item than the current item
	if ($(oCurrent).attr('href') != $(oNew).attr('href')) {
		// Update classes on  nav items
		$(oCurrent).removeClass("selected");
		$(oNew).addClass("selected");
		
		// Update current nav item
		currentNav = $(oNew);
		
		var newSlideHref = $(oNew).attr('href');
		var newSlide = newSlideHref.substr(newSlideHref.indexOf("#"), 7)

	// Fade photos to switch
		$(currentSlide).fadeOut('fast', function() {
			if(jQuery.browser.msie)
			 this.style.removeAttribute('filter');
		});
		$(newSlide).fadeIn('fast', function() {
			if(jQuery.browser.msie)
			 this.style.removeAttribute('filter');
		});
		
		// Update current item
		currentSlide = newSlide;
		iCurrent = Number(currentSlide.substring(6));
		
		clearInterval(timer);
		timer = setInterval("ChangeSlide($(currentNav), $('a#slideNav'+getNextID()))", (iSeconds*1000));
	};
};

/* Gets ID of next promo for auto-rotate */
function getNextID() {
	/*if (iCurrent==iMax) {
	iCurrent=1;
	} else {
		iCurrent=iCurrent+1;
	}*/
	iCurrent==iMax ? iCurrent=1 : iCurrent++;
	return iCurrent;
}

function getURLvals() {
	return window.location.href.slice(window.location.href.indexOf('?')).split(/[&?]{1}[\w\d]+=/);
}
