<?php

function customError($errno, $errstr) {
	echo "<b>Error:</b> [$errno] $errstr";
	die();
}
	

function createRandom($len) {    
$chars = "abcdefghijkmnopqrstuvwxyz023456789";    
srand((double)microtime()*1000000);    
$i = 0;    
$s = '' ;    
while ($i <= $len) {        
	$num = rand() % 33;        
	$tmp = substr($chars, $num, 1);        
	$s = $s . $tmp;        
	$i++;    
}    
return $s;
}


function print_header($body_script='', $anchor='') {

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="en">
<head>

<!-- START: META DATA -->
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="language" content="en">
<meta name="author" content=" ">
<meta name="subject" content=" ">
<meta name="keywords" content=" ">
<meta name="datecreated" content=" ">
<meta name="datereviewed" content=" ">
<!-- END: META DATA -->

<title>Repository</title>

<style type="text/css" media="screen,print">
    @import url(/va_files/2009/styles/va-user-styles.css);
    @import url(/va_files/2009/styles/vaSearch.css);
    @import url(/va_files/2009/styles/jkmegamenu.css);
    @import url(/va_files/2009/styles/va-styles.css);
</style>

<style type="text/css" media="screen">
	#prBanner { display:none; }
</style>

<style type="text/css" media="print">
	#prBanner { padding:0px; margin:0px; border:0px; position: relative; }
	#banner-wrapper { display:none; }
	#banner-area-menu { display:none; }
	#footer-area-links { display:none; }
</style>

<script type="text/javascript" src="/va_files/2009/scripts/global.js"></script>

<!-- START: SURVEY -->
<!---
<script type="text/javascript" src="/va_files/fsrscripts/triggerParams.js"></script>
<script type="text/javascript" src="/va_files/fsrscripts/stdLauncher.js"></script>
<script type="text/javascript">Poll();</script>
--->
<!-- END: SURVEY -->
</head>

<body class="mainbody" <?=$body_script?>>
<div id="skiplink"> 

	<? if ('' == $anchor) { ?>
		<a href="#content-wrapper">
	<? } else if ('skip_menu' == $anchor) { ?>
		<a href="#programs">
	<? } ?>
	skip to page content</a> </div>

<!-- START: OUTER CONTAINER -->
<div class="bdywrpr">

	<!-- START: VA PRINT BANNER -->
	<img src="/va_files/2009/images/inter-header-banner-print.gif" id="prBanner" width="996" height="100" alt="United States Department of Veterans Affairs" title="United States Department of Veterans Affairs">
	<!-- END: VA PRINT BANNER -->

	<!-- START: VA BANNER AND SEARCH FORM -->
	<div id="banner-wrapper">
		<!-- START: VA BANNER -->
		<div id="banner-image">
			<a href="http://www.domain/" title="United States Department of Veterans Affairs"><img src="/va_files/2009/images/inter-header-banner-va-seal.gif" width="538" height="94" alt="Official seal of the United States Department of Veterans Affairs" title="United States Department of Veterans Affairs"></a>
		</div>
		<!-- END: VA BANNER -->

		<!-- START: SEARCH FORM -->
		<div id="banner-area-search">
			<div id="search-area">
				<form name="searchForm" id="searchForm" method="GET" action="http://www.index.domain/search/va/va_search.jsp" style="margin:0px; padding:0px;">
					<!--- <script language="javascript" src="/va_files/2009/scripts/vaSearch.js" type="text/javascript"></script> Jason for security on 04/16/2015--->
					<input name="TT" type="hidden" id="TThidden" value="1">
					<!-- do not insert line breaks in the div tag below -->
					<div id="mainSearchForm"><label for="searchtxt" style="display:none">Enter your search text</label><input name="QT" type="text" id="searchtxt" size="5" title="Enter your search text" value=""><label for="searchbtn" style="display:none">Button to start search</label><input name="searchbtn" type="submit" id="searchbtn" title="Button to start search" value="Search"></div>
					<!-- do not insert line breaks in the div tag above -->
					<div id="moreLink">&raquo;&nbsp;<a href="http://www.index.domain/search/va/va_adv_search.jsp" style="color:#ffffff" title="Go to Advanced Search Page">Open Advanced Search</a></div>
				</form>
			</div>
		</div>
		<!-- END: SEARCH FORM -->
	</div>
	<!-- END: VA BANNER AND SEARCH FORM -->

	<!-- START: MEGA MENU -->
	<div id="banner-area-menu">
		<!-- START: GLOBAL MEGA MENU LINKS -->
		<script language="javascript" type="text/javascript">createMenu();</script>
		<noscript>
			<!-- START: NOSCRIPT FOR GLOBAL MEGA MENU LINKS -->
			<ul>
				<li><a href="http://www.domain/" title="main menu item Home">Home</a></li>
				<li><a href="http://www.domain/landing2_vetsrv.htm" title="main menu item Veteran Services">Veteran Services</a></li>
				<li><a href="http://www.domain/landing2_business.htm" title="main menu item Business">Business</a></li>
				<li><a href="http://www.domain/landing2_about.htm" title="main menu item About VA">About VA</a></li>
				<li><a href="http://www.domain/landing2_media_room.htm" title="main menu item Media Room">Media Room</a></li>
				<li><a href="http://www.domain/landing2_locations.htm" title="main menu item Locations">Locations</a></li>
				<li><a href="http://www.domain/landing2_contact.htm" title="main menu item Contact Us">Contact Us</a></li>
			</ul>
			<!-- END: NOSCRIPT FOR GLOBAL MEGA MENU LINKS -->
		</noscript>
		<!-- END: GLOBAL MEGA MENU LINKS -->

		<!-- START: LOCAL MEGA MENU (RELATED LINKS) -->

		<!-- END: LOCAL MEGA MENU (RELATED LINKS) -->
	</div>
	<!-- END: MEGA MENU -->

	<div id="content-wrapper">

		<!-- START: CONTENT -->
		<div id="content-area-template-B">
                    
                    
                    <table cellspacing="2" cellpadding="5" width="960" border="0">
<tbody>
<tr>
<td valign="top" align="left">

			<!-- START: PAGE CONTENT -->

<?php
}



function print_footer() {

?>
</td>
</tr>
</tbody>
</table>
<!-- END: PAGE CONTENT -->

	    </div>
		<!-- END: CONTENT -->

		<hr id="content-footer-divider">

		<!-- START: VA FOOTER -->
		<div id="footer-area">
			<p id="footer-area-links">
				<a href="http://www.domain/" title="VA Home">VA Home</a>&nbsp;|&nbsp;
				<a href="http://www.domain/privacy/" title="Privacy Policy">Privacy Policy</a>&nbsp;|&nbsp;
				<a href="http://www.foia.domain/" title="FOIA">FOIA</a>&nbsp;|&nbsp;
				<a href="http://www.domain/webpolicylinks.asp" title="Web Policies">Web Policies</a>&nbsp;|&nbsp;
				<a href="http://www.domain/orm/NOFEAR_Select.asp" title="No FEAR Act Data">No FEAR Act Data</a>&nbsp;|&nbsp;
				<a href="http://www.domain/general/site_map.htm" title="Site Index">Site Index</a>&nbsp;|&nbsp;
				<a href="http://www.domain/ext_redirect.asp?url=http://www.usa.gov/&amp;type=1" title="USA.gov">USA.gov</a>&nbsp;|&nbsp;
				<a href="http://www.domain/ext_redirect.asp?url=http://www.whitehouse.gov/&amp;type=1" title="White House">White House</a>&nbsp;|&nbsp;
				<a href="http://www.domain/ext_redirect.asp?url=http://www.nationalresourcedirectory.gov/&amp;type=1" title="National Resource Directory">National Resource Directory</a>&nbsp;|&nbsp;
				<a href="http://www.domain/oig/" title="Inspector General">Inspector General</a>
			</p>
			<p id="footer-address">U.S. Department of Veterans Affairs - 810 Vermont Avenue, NW - Washington, DC 20420</p>
		</div>
		<!-- END: VA FOOTER -->

		<p id="footer-review">Reviewed/Updated Date: <!-- START: LAST MOD DATE -->September 1, 2010<!-- END: LAST MOD DATE --></p>

	</div>

</div>
<!-- END: OUTER CONTAINER -->

</body>
</html>

<?php

}

function scrub_white_list ($input, $option='default') {
	$black_list = NULL;
	
	switch($option) {
			
		case 'ALPHAONLY':
			$white_list = "/[^A-Za-z_]+/";
			break;	
		
		case 'ALPHANUMERICONLY':
			$white_list = "/[^A-Za-z0-9]+/";
			break;

		case 'BASIC':
			$white_list = "/[^A-Za-z0-9_.\/\-]+/";
			//$white_list = "/[^A-Za-z0-9_ ,:?.()'%$\-*@\/!\#&=]+/";
			break;
			
		case 'DATA':
			$white_list = "/[^A-Za-z0-9_ ,.!@#$:%&*()\/\-]+/";
			break;
			
		case 'DATE':
			$white_list = "/[^0-9 .:\/\\\-]+/";
			break;

		case 'FILENAME':
			$white_list = "/[^A-Za-z0-9_.\-]+/";
			$input = basename($input); 	//basename(realpath($_GET));
			
			break;
			
		case 'HTMLNOSCRIPT':
			//$white_list = "/[^A-Za-z0-9_ .:\/&;'\"@#!()<>[],?\-]+/";
			$white_list = "/[^A-Za-z0-9_ .:\/&;'\"@=()<>[\],\-]+/";
			//$white_list = "/[^A-Za-z0-9_.]+/";
			
			$black_list = "/(<.*(script|object|applet|embed|eval|event|iframe|div|body|head|html|meta|link|span|class|input|src|href|submit|button).*(script|object|applet|embed|eval|event|iframe|div|body|head|html|meta|link|span|class|input|src|href|submit|button).*>)/i";	//|form|style
			//$black_list = "/(<.*(script|object|applet|embed|form|eval|event|iframe|div|style|a|body|head|html|meta|link|span|class|input|src).*(script|object|applet|embed|form|eval|event|iframe|div|style|a|body|head|html|meta|link|span|class|input|src).*>)/i";
			/*
			strPattern = "(<\s*(/)?(script|object|applet|embed|form|)\s*>)"   ' <  script xxx >
                        strPattern = strPattern & "|" & "(<.*>)"
                        strPattern = strPattern & "|" & "(&.{1,5};)"   ' &xxxx;
                        strPattern = strPattern & "|" & "eval\s*\("    ' eval  (
                        strPattern = strPattern & "|" & "(event\s*=)"  ' event  =
                    
                        'Now lets check for encoding
                        strPattern = Replace(strPattern, "<", "(<|%60|&lt;)")
                        strPattern = Replace(strPattern, ">", "(>|%62|&gt;)")
                        */
                        
			break;
		
		case 'INTERNALLINK':
			$white_list = "/[^A-Za-z0-9_.\-]+/";
			$black_list = "/(http|www|\.\.)/i";
			//$white_list = "/[^A-Za-z0-9_ ,:?.()'%$\-*@\/!\#&=]+/";
			
			$input = basename($input); 	//basename(realpath($_GET));
			
			break;
			
		case 'NUMBERONLY':
			$white_list = "/[^0-9]+/";
			break;
		
		case 'USER':
			$white_list = "/[^A-Za-z0-9_ .()\-@\+]+/";
			break;
		/*	
		case 'MAILBODY':
			$white_list = "/[^A-Za-z0-9_ .,():!?[]\-@\+]+/";
			break;
		*/		

		case 'XML':
			$white_list = "/[^A-Za-z0-9_ .'\"\\?#<>$:\/\-]+/";
			break;
			
		case 'default':	
		default:
			$white_list = "/[^A-Za-z0-9_ .]+/";
			break;
	}
		
	$output = preg_replace($white_list, '', $input);
	
	if (!is_null($black_list)){
		$output = preg_replace($black_list, '', $output);
	}
	
	$output = str_replace("..","",$output);
	
	return $output;
	
}

function scrub ($field) {
$field = str_replace("~","",$field);
$field = str_replace("#","",$field);
$field = str_replace("$","",$field);
$field = str_replace("%","",$field);
$field = str_replace("^","",$field);
$field = str_replace("*","",$field);
$field = str_replace("<","",$field);
$field = str_replace(">","",$field);
$field = str_replace("{","",$field);
$field = str_replace("}","",$field);
$field = str_replace("|","",$field);
$field = str_replace(";","",$field);
$field = str_replace("'","",$field);
$field = str_replace("\"","",$field);
$field = str_replace("\0","",$field);
$field = stripslashes($field);

return $field;
}

function scrub_sql ($field, $length=0) {
//addslashes($field);
//$field = str_replace("#","",$field);
//$field = str_replace("$","",$field);
//$field = str_replace("%","",$field);
//$field = str_replace("*","",$field);
//$field = str_replace("{","",$field);
//$field = str_replace("}","",$field);
//$field = str_replace(";","",$field);
//$field = str_replace("\"","",$field);
//$field = str_replace("/","",$field);

$field = str_replace("'","''",$field);
$field = str_replace("\\","\\\\",$field);
//$field = str_replace("//","////",$field);
$field = str_replace("\0","",$field);

//$field = str_replace("^","",$field);
//$field = str_replace("~","",$field);
//$field = str_replace("<","",$field);
//$field = str_replace(">","",$field);
//$field = str_replace("|","",$field);

//$field = stripslashes($field);
if ($length > 0) {
	$field = substr($field, 0, $length);
}

return $field;
}

function check_password($pwd) {
if (preg_match("/[a-z]/", $pwd) && preg_match("/[A-Z]/", $pwd) && preg_match("/[0-9]/", $pwd)) 
{
return true;
}

else {
return false;
}

}

function check_bad_char($field) {
$badCharacter = false;
$field = trim($field);
$charArray = preg_split('//', $field);

$badCharactersArray = array('#', '$', '%', '<', '>', '&', '!', '*', ' ');
for ($i = 0; $i < sizeof($badCharactersArray); $i++)
    {
        if (in_array ($badCharactersArray[$i], $charArray))
        {
            $badCharacter = true;
        }
    }

return $badCharacter;

}


function checklogin($userID, $target) {

if ($userID > 0) {
return true;
}
else {
header("Location: /index.php");
return false;
}

}


function insert_hmis_data($uniqid) {
	//Enter data into the db
	
}

function print_ajax_header() {
?>
	<script type="text/javascript">
	function enter_hmis_data()
	{
		var result = 0;
		document.forms['thisform'].process_data.disabled=true;
		document.getElementById("proc_msg").innerHTML="Processing Data. Please wait.";
		animate('proc_msg', '#ff8000');
		var file = document.forms['thisform'].file.value;
		var uldr = document.forms['thisform'].uldr.value;
		var zip = document.forms['thisform'].zip.value;
		var program_id = document.forms['thisform'].program_id.value;
		var dataset_id = document.forms['thisform'].dataset_id.value;
		var format_version = document.forms['thisform'].format_version.value;
		//var export_date = document.forms['thisform'].export_date.value;
		
		
		if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
			xmlhttp=new XMLHttpRequest();
		}
		else {// code for IE6, IE5
			xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
		} 
	
		xmlhttp.onreadystatechange = function () {
			
		  if (xmlhttp.readyState==4 && xmlhttp.status==200) {
			result = xmlhttp.responseText;
			document.getElementById("file_result").innerHTML=result;	//xmlhttp.responseText;
			animateloop('stop');
			document.getElementById("proc_msg").innerHTML="Processing Data Completed.";
		    }
		}
		
		//According to Mozilla's docs, you don't use onreadystatechange with synchronous requests. 
		//Use FireFox 4+ or check below
		//Even though the readystatechange event isnt firing, the readyState property is actually getting updated. 

		//xmlhttp.open("GET","hmis_ajax_handle.php?req=insert&file="+file+"&uldr="+uldr,false);
		xmlhttp.open("GET","hmis_ajax_handle.php?req=insert&file="+file+"&uldr="+uldr+"&zip="+zip+"&program_id="+program_id+"&dataset_id="+dataset_id+"&format_version="+format_version,true);	//+"&export_date="+export_date
		xmlhttp.send();
				
		//thisform.file_result.value = result
	 }	 
	</script>

<SCRIPT language="JavaScript"  type="text/javascript">

        var ie4 = false;
        if(document.all) {
                ie4 = true; 
        }       
        function setContent(name, value) {
                var d;  
                if (ie4) { 
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }       
                d.innerHTML = value;    
        }       

	function getContent(name) {
		var d;
                if (ie4) {
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                return d.innerHTML;
	}

        function setColor(name, value) {
                var d;  
                if (ie4) { 
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                d.style.color = value;  
        }

	function getColor(name) {
                var d;
                if (ie4) {
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                return d.style.color;
        }

        function animate(name, col, mode) {

		var value = getContent(name);
		if (value.indexOf('<span') >= 0) { return; }
		var length = 0;
		var str = '';
		var ch;
		var token = '';
		var htmltag = false;	
		for (i = 0; i < value.length; i++) {
			ch = value.substring(i, i+1);
			if (i < value.length - 1) { nextch = value.substring(i+1, i+2); } else { nextch = ' '; }
			token += ch;
			if (ch == '<' && '/aAbBpPhHiIoOuUlLtT'.indexOf(nextch) >= 0) { htmltag = true; }
			if (ch == '>' && htmltag) { htmltag = false; }
			if (!htmltag && ch.charCodeAt(0) > 30 && ch != ' ' && ch != '\n') {		
				str += '<span id="' + name + '_' + length + '">' + token + '</span>';
				token = '';
				length++;
			}
		}
		setContent(name, str);
		command = 'animateloop(\'' + name + '\', ' + length + ', 0, 1, \'' + col + '\')';
		setTimeout(command , 100);
                
        }

        function animateloop(name, length, ind, delta, col) {
        	if(name=="stop"){
        		exe = clearTimeout(exe);
        	} else {
			var next = ind + delta;
			if (next >= length) { delta = delta * -1; next = ind + delta; }
			if (next < 0) { delta = delta * -1; next = ind + delta; }
			setColor(name + '_' + ind, getColor(name + '_' + next));
			setColor(name + '_' + next, col);
			command = 'animateloop(\'' + name + '\', ' + length + ', ' + next + ', ' + delta + ', \'' + col + '\')';
			exe = setTimeout(command , 100);
                }
        }
</SCRIPT>
	
<?
}

function print_ajax_form($zip_file,$program_id,$dataset_id,$format_version) {
	/*
	echo "\n" . '<br><br>
	<form name="thisform" action="" method="post" id="thisform">
		<div>
			<input name="file" id="file" type="hidden" value="' . $_SESSION['uniq_id'] . '"/>
			' . $spacer . '<input name="process_data" type="button" value="Process Data" onclick="enter_hmis_data()" />
			<span id="file_result"></span>
		</div>
	</form>
	';*/
	
	$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
?>
	<br><br>
	<form name='thisform' action='' method='post' id='thisform'>
		<div>
			<input name='file' id='file' type='hidden' value='<?=$_SESSION['uniq_id']?>'/>
			<input name='uldr' id='uldr' type='hidden' value='<?=$_SESSION['userID']?>'/>
			<input name='zip' id='zip' type='hidden' value='<?=$zip_file?>'/>
			<input name='program_id' id='program_id' type='hidden' value='<?=$program_id?>'/>
			<input name='dataset_id' id='dataset_id' type='hidden' value='<?=$dataset_id?>'/>
			<input name='format_version' id='format_version' type='hidden' value='<?=$format_version?>'/>
			<!--- increment3 <input name='export_date' id='export_date' type='hidden' value='<?=$export_date?>'/> 
			<input name='process_data' type='button' value='Upload Data' onclick='enter_hmis_data()' /> --->
			
			<?=$spacer?><input name='process_data' type='button' value='Upload Data' onclick='enter_hmis_data()' /> <span id='proc_msg'></span><br><br>
			<!--- <style onload='enter_hmis_data();'><style> --->
			<span id='file_result'></span>
		</div>
	</form>


<?
}

function delete_hmis_files($dirname) { 
	//Todo rm -rf $path/$folder_id
	
   if (is_dir($dirname)) 
      $dir_handle = opendir($dirname); 
   if (!$dir_handle) 
      return false; 
   while($file = readdir($dir_handle)) { 
      if ($file != "." && $file != "..") { 
         if (!is_dir($dirname."/".$file)) 
            unlink($dirname."/".$file); 
         else 
            delete_hmis_files($dirname.'/'.$file);     
      } 
   } 
   closedir($dir_handle); 
   rmdir($dirname); 
   return true; 
}

function inactivate_hmis_data($data_id, $dataset_id = 4) {
	global $db;
		
	if(4 == $dataset_id) {
		$sql = 'BEGIN TRANSACTION
				UPDATE HMIS_Files SET status=\'INACTIVE\' WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_Client SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_Enrollment SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_EnrollmentCoC SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_Exit SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_Export SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_IncomeBenefits SET status=2 WHERE file_id=\'' . $data_id . '\';
	
				UPDATE td_Project SET status=2 WHERE file_id=\'' . $data_id . '\';
				
				UPDATE td_ProjectCoC SET status=2 WHERE file_id=\'' . $data_id . '\';
				
				UPDATE td_Services SET status=2 WHERE file_id=\'' . $data_id . '\';
			
			COMMIT
			';
		
	} else {
		$sql = 'BEGIN TRANSACTION
				UPDATE HMIS_Files SET status=\'INACTIVE\' WHERE file_id=\'' . $data_id . '\';
	
				UPDATE data_AgencyProgram SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_Client SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_ClientHistorical SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_Export SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_IncomeBenefits SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_ProgramParticipation SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
	
				UPDATE data_ServiceEvent SET status=\'INACTIVE\' WHERE FileID=\'' . $data_id . '\';
			
			COMMIT
			';
	}

	$rs = $db->Execute($sql);
	$result = 'SUCCESS';
	
	return $result;
}

function activate_hmis_data($data_id) {
	global $db;
	$sql = 'BEGIN TRANSACTION
			UPDATE HMIS_Files SET status=\'ACTIVE\' WHERE file_id=\'' . $data_id . '\';

			UPDATE data_AgencyProgram SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_Client SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_ClientHistorical SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_Export SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_IncomeBenefits SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_ProgramParticipation SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';

			UPDATE data_ServiceEvent SET status=\'ACTIVE\' WHERE FileID=\'' . $data_id . '\';
		
		COMMIT
		';
	$rs = $db->Execute($sql);
	$result = 'SUCCESS';
	
	return $result;
}

function inactivate_all_previous_data($user_id, $program_id, $file_id, $dataset_id) {

	global $db;
	
	if(4 == $dataset_id) {
		$sql = 'BEGIN TRANSACTION
				UPDATE HMIS_Files SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_Client SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_Enrollment SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_EnrollmentCoC SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_Exit SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_Export SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_IncomeBenefits SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE td_Project SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
				
				UPDATE td_ProjectCoC SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
				
				UPDATE td_Services SET status=2 WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
			
			COMMIT
			';
		
	} else {
		$sql = 'BEGIN TRANSACTION
				UPDATE HMIS_Files SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND file_id<>\'' . $file_id . '\';
	
				UPDATE data_AgencyProgram SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_Client SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_ClientHistorical SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_Export SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_IncomeBenefits SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_ProgramParticipation SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
	
				UPDATE data_ServiceEvent SET status=\'INACTIVE\' WHERE (program_id = \'' . $program_id . '\') AND FileID<>\'' . $file_id . '\';
			
			COMMIT
			';
	}
	
	$rs = $db->Execute($sql);
	$result = 'SUCCESS';
	
	return $result;
	
}

function audit_log($userID, $message, $event_type = 0, $var1 = NULL, $var2 = NULL) {
	global $db;
	$sql = "INSERT INTO tb_audit (user_id, event, event_date, event_type, event_var, event_var2) VALUES ($userID, '$message', getdate(), $event_type, '$var1', '$var2')";
	$rs = $db->Execute($sql);
}

function toggle_hmis_onoff($onoff) {
	global $db;
	$sql = "UPDATE HMIS_Config SET value = '$onoff' WHERE name = 'user_login_switch'";
	$rs = $db->Execute($sql);
}

function capture_upload_report($userID,$file_upload_report) {
	global $db;

	$file_upload_report = htmlentities($file_upload_report, ENT_QUOTES);
	$file_name = scrub_sql(scrub_white_list($_SESSION['zip_file'], 'FILENAME'), 50);

	$sql = 'SET TEXTSIZE 2147483647 INSERT INTO HMIS_Upload_Reports (file_id, user_id, file_name, error_msg) VALUES (\''. $_SESSION['uniq_id'] . '\', ' . $userID . ', \'' . $file_name . '\', \'' . $file_upload_report . '\')';

	$rs = $db->Execute($sql);
}

function insert_validated_data($zip_file,$program_id,$dataset_id) {
		
		global $db;
		global $file_upload_path;
		global $valid_file_names;
		global $valid_file_names_v4;
		
		$file_id = scrub_white_list($_SESSION['uniq_id'], 'ALPHANUMERICONLY');
		$user_id = scrub_white_list($_SESSION['userID'], 'NUMBERONLY'); 
		$zip_file_name = scrub_white_list($zip_file, 'FILENAME');
		$program_id = scrub_white_list($program_id, 'BASIC');
		$dataset_id = scrub_sql(scrub_white_list($dataset_id, 'NUMBERONLY'), 1);

		$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
		
		if (!is_numeric($user_id)) {
			echo 'Error. Invalid uldr: ' . $user_id;
			exit;
		}

		if ( 4 == $dataset_id ) {
			$valid_file_names = $valid_file_names_v4;
			$valid_file_name_count = $valid_file_name_count_v4;
			$status_init = 1;
			
		} else {
			
		}

		$tmp_work_dir = $file_upload_path . $file_id . '/';
		$tmp_work_unzip_dir = $tmp_work_dir . 'unzip/';

		if ($dh = opendir($tmp_work_unzip_dir)) {
			$file_num = 0;
			while ( ($file_name = readdir($dh)) !== false ) {
				if ( !(('.' == $file_name) || ('..' == $file_name)) ) {
					$file_num++;
					$new_file_name =  strtolower (str_replace('_', '', trim($file_name)));
					echo 'Index ' . $file_num . ": <b>$file_name</b> "; 

					if (in_array($new_file_name, $valid_file_names)) {
					
						$sql = 'Select * From FileFormat Where format_name = \'' . $new_file_name . '\' and format_version = ' . $dataset_id . ' Order By format_order';
						$rs = $db->Execute($sql) or die ("<br>Select file failed");
						$record_count = $rs->RecordCount();
			
						if (($handle = fopen($tmp_work_unzip_dir . $file_name, "r")) !== FALSE) {

							$row = 0;
							$total_row = count(file($tmp_work_unzip_dir . $file_name));
							$actual_num_row = $total_row - 1;
			
							echo '['. $total_row . ' rows found in the file.] <br>';
							$insert_sql_head = 'Insert Into ';
							$skip_file = 'N';
							
							if ( 4 == $dataset_id ) {
								
								switch ($new_file_name) {
									
									case 'export.csv':
										$insert_sql_head .= 'td_Export (';
										break;
										
									case 'exit.csv':
										$insert_sql_head .= 'td_Exit (';
										break;
										
									case 'client.csv':
										$insert_sql_head .= 'td_Client (';
										break;
										
									case 'enrollment.csv':
										$insert_sql_head .= 'td_Enrollment (';
										break;
										
									case 'enrollmentcoc.csv':
										$insert_sql_head .= 'td_EnrollmentCoC (';
										break;
										
									case 'project.csv':
										$insert_sql_head .= 'td_Project (';
										break;
										
									case 'projectcoc.csv':
										$insert_sql_head .= 'td_ProjectCoC (';
										break;
										
									case 'services.csv':
										$insert_sql_head .= 'td_Services (';
										break;
										
									case 'incomebenefits.csv':
										$insert_sql_head .= 'td_IncomeBenefits (';
										break;
										
									default:
										
										$skip_file = 'Y';
										echo '<b><font color="red">Notice:</font></b> Unsupported file: ' . $file_name . ' is skipped. <br>';
										
										break;		
								}
								
							} else {
								switch ($new_file_name) {
									
									case 'export.csv':
										$insert_sql_head .= 'data_Export (';
										break;
										
									case 'agencyprogram.csv':
										$insert_sql_head .= 'data_AgencyProgram (';
										break;
										
									case 'client.csv':
										$insert_sql_head .= 'data_Client (';
										break;
										
									case 'clienthistorical.csv':
										$insert_sql_head .= 'data_ClientHistorical (';
										break;
										
									case 'incomebenefits.csv':
										$insert_sql_head .= 'data_IncomeBenefits (';
										break;
										
									case 'serviceevent.csv':
										$insert_sql_head .= 'data_ServiceEvent (';
										break;
										
									case 'programparticipation.csv':
										$insert_sql_head .= 'data_ProgramParticipation (';
										break;
										
									default:
										
										$skip_file = 'Y';
										echo '<b><font color="red">Notice:</font></b> Unsupported file: ' . $file_name . ' is skipped. <br>';
										
										break;		
								} 
								
							}
							
							while (($data = fgetcsv($handle)) !== FALSE && 'N' == $skip_file) {
								
								$num = count($data);
								
								if ( 4 == $dataset_id ) {
									$insert_sql_columns = 'File_ID, Program_ID, Status';
									$insert_sql_values = 'Values (\'' . $file_id . '\', ' . $program_id. ', ' . $status_init;
								} else {
									$insert_sql_columns = 'FileID, UserID';
									$insert_sql_values = 'Values (\'' . $file_id . '\', ' . $user_id;
								}
														
								$row++;
								if (1 == $row) {
									
									continue;
								}
								
								
								$rs->movefirst();
								
								for ($c=0; $c < $num; $c++) {
									
									$col_num = $c + 1;
									$value = scrub_white_list($data[$c], 'DATA');
									$data_length = strlen($value);
									
									$field_name = $rs->fields('field_name');
									$data_type = $rs->fields('data_type');
									//$allow_null = $rs->fields('allow_null');
									//$pick_list = $rs->fields('pick_list');
									$field_length = $rs->fields('field_length');
									$skip_data = $rs->fields('skip_data');
								
									if ('N' == $skip_data) {
										
										if ('N' == $data_type) {
											if (0 != strlen(trim($value))) {
												$insert_sql_columns .= ', ' . $field_name;
												$insert_sql_values .= ', ' . scrub_sql($value, $field_length);
											}
											
										} else {
											$insert_sql_columns .= ', ' . $field_name;
											$insert_sql_values .= ', \'' . scrub_sql($value, $field_length) . '\'';
										}
									}
	
									$rs->movenext();
								}	
								
								
								$insert_sql_columns .= ') ';
								$insert_sql_values .= ') ';
										
								$insert_sql = $insert_sql_head . $insert_sql_columns . $insert_sql_values;
								
								$rs_insert = $db->Execute($insert_sql) or die ("<br>Insert data failed.");
								
	
							}	
							echo ' - <font color="blue"><b>Data insert Successful.</b></font> <br>';
							
						} else {
							
							$result = 'Error. File not available.';
						}
					} else {
						echo '<br> - <b><font color="red">Data insert skipped.</font> This is not a supported file name.</b><br>';
					}
					
				
				
				} //end . & ..
				
			}	
			closedir($dh);
		} else {
			
			$result = 'Error. Folder not available.';
		}

		
		echo '<br><br><b>Step 4. DB Insert </b>';
		
		$rs = $db->Execute("SELECT TOP 10 * FROM HMIS_Files ORDER BY ID ASC");
		$arr = $rs->GetArray();
		

		
		$zip_file_path = $tmp_work_dir . $zip_file_name;
		
		$file_content = file_get_contents($zip_file_path);
		$hex_file_content = '0x'.bin2hex($file_content);
		$safe_zip_file_name = scrub_sql($zip_file_name, 50);
		
		$sql = 'Insert Into HMIS_Files (file_id, user_id, program_id, dataset_id, name, zipfile, file_type, validation, data_insert) Values (';
		$sql .= "'$file_id', '$user_id', '$program_id', '$dataset_id', '$safe_zip_file_name', $hex_file_content, 'CSV', 1, 1)";
		$rs = $db->Execute($sql) or die ("<br>Insert file failed");

		$zip_file_id = $db->Insert_ID();
		$result = '<br><br>' . $spacer . '<font color="navy">* ' . $zip_file_name.' with file id ' . $zip_file_id . ' has been inserted successfully to the database.</font>';
		echo $result;
		
		$sql = 'Update tb_SSVF_program SET status = 3, upload_id = \'' . $file_id . '\', upload_date = getdate()  Where program_id = ' . $program_id;
		$rs = $db->Execute($sql) or die ("<br>Insert file failed");
		
		$result = '<br>' . $spacer . '<font color="navy">* Program Status has been updated as completed.</font>';
		echo $result;
		
		$sql = 'Select name, zipfile From HMIS_Files Where id = ';
		$sql .= "'$zip_file_id'";
		$rs = $db->Execute($sql) or die ("<br>Select file failed");

		if ( 4 == $dataset_id ) {
			
			$sql = 'SELECT * from dbo.GetSummary (\'' . $file_id . '\')';
			$rs = $db->Execute($sql) or die ("<br>Select data summary failed");
			
			echo '<br><br><br><b>[ Data Summary ]</b><br>';
			//echo '<table border="0"><tr><td> Category </td> <td> Value </td></tr>';
			echo '<table border="0"><tr><td> </td> <td>  </td></tr>';
			while (!$rs->EOF) {
				
				echo '<tr><td>' . $rs->fields('category') . '</td>';
				echo '<td> : ' . $rs->fields('number') . '</td></tr>';
				
				$rs->MoveNext();
			}
			echo '</table>';
		}
		
		$rs->Close();
		
		$result = '<br><br>' . $spacer . '<font color="navy"><b>The upload was successful and the data has been accepted.</b></font>';
		delete_hmis_files($tmp_work_dir);
		
		
		inactivate_all_previous_data($user_id, $program_id, $file_id, $dataset_id);
		
		$message = 'User inserted data';
		audit_log($user_id, $message, 61, $file_id, $program_id);
		
		echo $result;
}

function print_ajax_squares_header() {
?>
	<script type="text/javascript">
		
	function enter_squares_data()
	{
		var result = 0;
		
		document.getElementById("proc_msg").innerHTML="Processing Data. Please wait.";
		animate('proc_msg', '#ff8000');
		var hmis_id = document.forms['validate'].hmis_id.value;
		var fname = document.forms['validate'].fname.value;
		var mname = document.forms['validate'].mname.value;
		var lname = document.forms['validate'].lname.value;
		var ssn = document.forms['validate'].ssn.value;
		var gender = document.forms['validate'].gender.value;
		var dob = document.forms['validate'].dob.value;
		var zip = document.forms['validate'].zip.value;
		var uldr = "<?=$_SESSION['userID']?>";
		
		
		if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
			xmlhttp=new XMLHttpRequest();
		}
		else {// code for IE6, IE5
			xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
		} 
	
		xmlhttp.onreadystatechange = function () {
			
		  if (xmlhttp.readyState==4 && xmlhttp.status==200) {
			result = xmlhttp.responseText;
			document.getElementById("file_result").innerHTML=result;	//xmlhttp.responseText;
			animateloop('stop');
			document.getElementById("proc_msg").innerHTML="Processing Data Completed.";
		    }
		}
		
		//According to Mozilla's docs, you don't use onreadystatechange with synchronous requests. 
		//Use FireFox 4+ or check below
		//Even though the readystatechange event isnt firing, the readyState property is actually getting updated. 

		//xmlhttp.open("GET","hmis_ajax_handle.php?req=insert&file="+file+"&uldr="+uldr,false);
		
		
		xmlhttp.open("GET","evh_squares_client.php?req=search&hmis_id="+hmis_id+"&fname="+fname+"&mname="+mname+"&lname="+lname+"&ssn="+ssn+"&gender="+gender+"&dob="+dob+"&zip="+zip+"&uldr="+uldr,true);	//+"&export_date="+export_date
		xmlhttp.send();
				
		//document.getElementById("query_result").value = result;
		//validate.file_result.value = result
	 }

	
	</script>

<SCRIPT language="JavaScript"  type="text/javascript">

        var ie4 = false;
        if(document.all) {
                ie4 = true; 
        }       
        function setContent(name, value) {
                var d;  
                if (ie4) { 
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }       
                d.innerHTML = value;    
        }       

	function getContent(name) {
		var d;
                if (ie4) {
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                return d.innerHTML;
	}

        function setColor(name, value) {
                var d;  
                if (ie4) { 
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                d.style.color = value;  
        }

	function getColor(name) {
                var d;
                if (ie4) {
                        d = document.all[name];
                } else {
                        d = document.getElementById(name);
                }
                return d.style.color;
        }

        function animate(name, col, mode) {

		var value = getContent(name);
		if (value.indexOf('<span') >= 0) { return; }
		var length = 0;
		var str = '';
		var ch;
		var token = '';
		var htmltag = false;	
		for (i = 0; i < value.length; i++) {
			ch = value.substring(i, i+1);
			if (i < value.length - 1) { nextch = value.substring(i+1, i+2); } else { nextch = ' '; }
			token += ch;
			if (ch == '<' && '/aAbBpPhHiIoOuUlLtT'.indexOf(nextch) >= 0) { htmltag = true; }
			if (ch == '>' && htmltag) { htmltag = false; }
			if (!htmltag && ch.charCodeAt(0) > 30 && ch != ' ' && ch != '\n') {		
				str += '<span id="' + name + '_' + length + '">' + token + '</span>';
				token = '';
				length++;
			}
		}
		setContent(name, str);
		command = 'animateloop(\'' + name + '\', ' + length + ', 0, 1, \'' + col + '\')';
		setTimeout(command , 100);
                
        }

        function animateloop(name, length, ind, delta, col) {
        	if(name=="stop"){
        		exe = clearTimeout(exe);
        	} else {
			var next = ind + delta;
			if (next >= length) { delta = delta * -1; next = ind + delta; }
			if (next < 0) { delta = delta * -1; next = ind + delta; }
			setColor(name + '_' + ind, getColor(name + '_' + next));
			setColor(name + '_' + next, col);
			command = 'animateloop(\'' + name + '\', ' + length + ', ' + next + ', ' + delta + ', \'' + col + '\')';
			exe = setTimeout(command , 100);
                }
        }
        
</SCRIPT>
	
<?
}


?>
