<?

	Class HMISValidator {
	
		private $num_error;
		private $valid_file_names;
		
		function __construct ($valid_names) {
			$this->num_error = 0;
			$this->error_msg = '';
			$this->valid_file_names = $valid_names;
		}
		
		function validate_v4 ($file_name, $tmp_dir_unzip, $validation_result, $format_version) {
			

			$new_file_name =  strtolower (str_replace('_', '', $file_name));
			$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
			global $file_upload_report;
			$msg = '<b>' . $file_name . '</b> ';
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
			
			if(!HMISValidator::is_file_name_valid($new_file_name)) {

				
				$this->error_msg = $new_file_name . ' does not match any of the expected HMIS CSV format file names.';
				$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error');
				
				array_push($validation_result['error']['error_msg'], $this->error_msg);
				$validation_result['error']['error_count']++;
				
				//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg;
				
			} else {
				
				//$validation_result['file_name']["$file_name"]['detail'] = $file_name; //delete after testing
			}
			
			global $db;
			$PID = '';
			$column_error = FALSE;
			$sql = 'SELECT [val_type], [p_start_date]
				FROM tb_SSVF_program
				WHERE [program_id] = ' . $_SESSION['program_id'];
			$rs = $db->Execute($sql) or die ("<br>Select validation type failed. ");
			$val_type = $rs->fields('val_type');
			$p_start_date = $rs->fields('p_start_date');
			
			//$sql = 'Select * From FileFormat Where format_name = \'' . $new_file_name . '\' Order By format_order';			
			$sql = 'SELECT ff.[format_id]
				,ff.[format_order]
				,ff.[format_name]
				,ff.[field_name]
				,ff.[data_type]
				,ff.[allow_null]
				,ff.[pick_list]
				,ff.[field_length]
				,ff.[skip_data]
				,ff.[util_rate_ack_type]
				,ff.[util_rate_ack]
				,ff.[util_rate_rej_type]
				,ff.[util_rate_rej]
				,ff.[pick_values]
				,hct.[program_id]
				,hct.[util_rate_ack_type] as hct_util_rate_ack_type
				,hct.[util_rate_ack] as hct_util_rate_ack
				,hct.[util_rate_rej_type] as hct_util_rate_rej_type
				,hct.[util_rate_rej] as hct_util_rate_rej
			FROM FileFormat ff left join 
				(Select * from HMIS_Custom_Threshold Where program_id = ' . $_SESSION['program_id'] . ') hct
				On ff.format_id = hct.format_id
			Where ff.format_name = \'' . $new_file_name . '\' and ff.format_version = ' . $format_version . '
			order by ff.format_order';
			
			$rs = $db->Execute($sql) or die ("<br>$sql <br>Select file failed");
			$record_count = $rs->RecordCount();
			
			if (($handle = fopen($tmp_dir_unzip . $file_name, "r")) !== FALSE) {
				$row = 0;
				$total_row = count(file($tmp_dir_unzip . $file_name));
				$actual_num_row = $total_row - 1;
				$msg = '['. $total_row . ' rows found in the file.] <br>';
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;
			
				while (($data = fgetcsv($handle)) !== FALSE) {
					$num = count($data);
					
					if ($num != $record_count && FALSE == $column_error){
						$this->error_msg = 'Unable to process.  The structure of this file is incorrect.  There should be ' . $record_count . ' columns but the file contains ' . $num . ' columns.';	//' columns but row ' . $row . ' has ' . $num . ' columns.';
						$this->num_error++;
						
						$column_error = TRUE;
						
						$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error');
						
						array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
						$validation_result['error']['error_count']++;
						
					}
					
					$row++;
					if (1 == $row) {
						continue;
					}
					
					$rs->movefirst();
					
					for ($c=0; $c < $num; $c++) {
						
						$col_num = $c + 1;
						$value = trim(scrub_white_list($data[$c], 'DATA'));
						$data_length = strlen(trim($value));
						
						$field_name = trim($rs->fields('field_name'));
						$data_type = $rs->fields('data_type');
						$allow_null = $rs->fields('allow_null');
						$pick_list = $rs->fields('pick_list');
						$field_length = $rs->fields('field_length');
						$skip_data = $rs->fields('skip_data');
						
						if ( 1 == $val_type && !is_Null($rs->fields('program_id'))) {
							$arr_util_rate_ack_type = str_getcsv($rs->fields('hct_util_rate_ack_type'));
							$util_rate_ack = $rs->fields('hct_util_rate_ack');
							$arr_util_rate_rej_type = str_getcsv($rs->fields('hct_util_rate_rej_type'));
							$util_rate_rej = $rs->fields('hct_util_rate_rej');
							
						} else {
							$arr_util_rate_ack_type = str_getcsv($rs->fields('util_rate_ack_type'));
							$util_rate_ack = $rs->fields('util_rate_ack');
							$arr_util_rate_rej_type = str_getcsv($rs->fields('util_rate_rej_type'));
							$util_rate_rej = $rs->fields('util_rate_rej');
						}

						if ('export.csv' == $new_file_name) {
							
							if ('ExportID' == $field_name) {
								$validation_result["$new_file_name"]['data']['ExportID'] = $value;
							} else if ('ExportDate' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportDate'] = $value;
							} else if ('ExportStartDate' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportStartDate'] = $value;
								
								$begin_date = strtotime($value);
								$program_start_date = strtotime($p_start_date);
								
								if ($begin_date > $program_start_date) {
									
									$this->error_msg = 'Unable to process.  ExportStartDate is ' . $value . '. Your ExportStartDate must be on or before ' . $p_start_date . '.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
									
								/*
								$date_limit1 = strtotime('10/01/2011');
								$date_limit2 = strtotime('10/01/2012');
								$date_limit3 = strtotime('10/01/2013');
								
								$begin_date = strtotime($value);
								//echo '<br>grant id: ' . $_SESSION['grant_id'] . ' begin: ' . $begin_date . '<br>';
								
								if ( 104 >= $_SESSION['grant_id'] && $date_limit1 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2011.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									
								} else if ( 104 < $_SESSION['grant_id'] && $_SESSION['grant_id'] < 200 && $date_limit2 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2012.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								} else if ( 200 <= $_SESSION['grant_id'] && $date_limit3 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2013.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
								*/
								
							} else if ('ExportEndDate' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportEndDate'] = $value;
								
								if (substr ($validation_result["$new_file_name"]['data']['ExportDate'], 0, 10) != $value) {

									$this->error_msg = 'Unable to process.  The end of the export period for this upload is ' . $value . ' but the date of the export is ' . $validation_result["$new_file_name"]['data']['ExportDate'] . ' Please use the date that the export is generated as the end date.';
									
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								}
								
							} else if ('SourceContactPhone' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'phone') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  Phone number ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							} else if ('SourceContactExtension' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'ext') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  Phone number extension ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							} else if ('SourceContactEmail' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'email') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  Email address ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							}
							
						} else {

							 if ( 'ExportID' == $field_name && ($value != $validation_result['export.csv']['data']['ExportID']) ) {

								/*
								$cur_err_cnt = $validation_result["$new_file_name"]['rej_count'];
								$validation_result["$new_file_name"]["$cur_err_cnt"]['rej_msg'] = $this->error_msg;
								$validation_result["$new_file_name"]['rej_count']++;
								*/
								$this->error_msg = 'Unable to process.  This file appears to include records from more than one export.  The Repository can only process data from a single export.  (ExportID in file: ' . $value . '. ExportID in Export.csv: ' . $validation_result['export.csv']['data']['ExportID'] . ')';
								$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
								//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
								$validation_result['error']['rej_count']++;
							}
						}
						
						if ('project.csv' == $new_file_name) {
							
							if ('OrganizationID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['OrganizationID'], $value);
								
							} else if ('ProjectID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['ProjectID'], $value);
								
							} else if ('DateCreated' == $field_name && strtotime($value) > strtotime($validation_result['export.csv']['data']['ExportStartDate'])){

								//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								
							}  else if ('ContinuumProject' == $field_name) {
								
								array_push($validation_result["$new_file_name"]['data']['ContinuumProject'], $value);
								
							} else if  ('ProjectType' == $field_name) {
								
								array_push($validation_result["$new_file_name"]['data']['ProjectType'], $value);
								
								$continuum_project = array_pop($validation_result["$new_file_name"]['data']['ContinuumProject']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['ContinuumProject'], $continuum_project);
								
								if ( 1 != $continuum_project && 0 == strlen(trim($value)) ) {
									
									$this->error_msg = 'Unable to process.  Project type cannot be null if ContinuumProject field value is not 1. (Continuum Project value: ' . $value . ')';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
							} else if  ('ResidentialAffiliation' == $field_name) {
								
								$project_type = array_pop($validation_result["$new_file_name"]['data']['ProjectType']);
								array_push($validation_result["$new_file_name"]['data']['ProjectType'], $project_type);
								
								if ( 6 != $ProjectType && 0 != strlen(trim($value)) ) {
									
									$this->error_msg = 'Data quality warning.  ResidentialAffiliation field value ' . $value . ' should be null if ProjectType is not 6.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
									
								}
								
							} else if  ('Tracking Method' == $field_name) {
								
								$project_type = array_pop($validation_result["$new_file_name"]['data']['ProjectType']);
								array_push($validation_result["$new_file_name"]['data']['ProjectType'], $project_type);
								
								if ( 1 != $ProjectType && 0 != strlen(trim($value)) ) {
									
									//Ack
									$this->error_msg = 'Data quality warning.  TrackingMethod field value ' . $value . ' should be null if ProjectType is not 1.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
									
								}
							}
						}
						
						if ('projectcoc.csv' == $new_file_name) {
							
							if ('ProjectID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['ProjectID'], $value);
								
							} else if ('CoCCode' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['CoCCode'], $value);
								
								if (!HMISValidator::validate_regex($value, 'coccode') && 0 != strlen(trim($value))) {
									$this->error_msg = 'Data quality warning.  CoCCode ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							
								
							}
							
						}

						if ('enrollment.csv' == $new_file_name) {
							
							if ( 'PersonalID' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $value);
								

								
							} else if ('LastPermanentState' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'state') && 0 != strlen(trim($value))) {
									$this->error_msg = 'Data quality warning.  LastPermanentState ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							} else if ('LastPermanentZip' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'zip') && 0 != strlen(trim($value))) {

									$this->error_msg = 'Data quality warning.  LastPermanentZip ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							}
						}
						
						
						if ('enrollmentcoc.csv' == $new_file_name) {
							
							if ('CoCCode' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'coccode') && 0 != strlen(trim($value))) {

									$this->error_msg = 'Data quality warning.  CoCCode ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							}
							
						}
						
						if ('client.csv' == $new_file_name) {

							if ( 'PersonalID' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $value);
								$PID = $value;
								
								
								if (!in_array($PID, $validation_result['enrollment.csv']['data']['PersonalID'])) {
									
									$this->error_msg = 'Unable to process.  PersonalID ' . $value . ' is not found in enrollment.csv file';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
								
							} else {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalID']);
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $PID);
							}
						
							 if ('SSN' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'ssn') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  SSN ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							} else if ('YearEnteredService' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'YES') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  YearEnteredService ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							} else if ('YearSeparated' == $field_name){
								
								if (!HMISValidator::validate_regex($value, 'YES') && 0 != strlen(trim($value))) {
									//Ack
									$this->error_msg = 'Data quality warning.  YearSeparated ' . $value . ' is not in a valid format.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							}
							
						}
						
						if ('exit.csv' == $new_file_name) {
							//
						}
						
						
						if ('incomebenefits.csv' == $new_file_name) {
							/* version 4
							if ( 'IncomeBenefitType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $value);
								
							}
							*/
							if ( 'PersonalID' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $value);
								$PID = $value;
								
							} else if ('DisabilitiesID' != $field_name || 'ProjectEntryID' != $field_name) {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalID']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $PID);
							}

						}
						
						
						if ('serviceevent.csv' == $new_file_name) {
							
							if ( 'PersonalID' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $value);
								$PID = $value;
								$validation_result['count']['service_records']++;
						
							} else {
							
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalID']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalID'], $PID);
							}
							
							if ( 'ServiceEventStartDate' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $value);
								
							} else if ( 'ServiceEventType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $value);
								
							} else if ( 'ServiceCode' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $value);
								
							}

						}
						
						
						$project_id_check = array('projectcoc.csv', 'enrollment.csv', 'enrollmentcoc.csv');
						if (in_array($new_file_name, $project_id_check)) {	
							
							if ( 'ProjectID' == $field_name ){
								
								if (!in_array($value, $validation_result['project.csv']['data']['ProjectID'])) {
									
									$project_id = array_pop($validation_result['project.csv']['data']['ProjectID']);
									//put the value back to the array
									array_push($validation_result['project.csv']['data']['ProjectID'], $project_id);
									
									//Rej
									$this->error_msg = 'Unable to process.  ProjectID: ' . $value . ' does not match any value in Project.csv';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
								
							}
						}

						$cnt_ack = count($arr_util_rate_ack_type);
						$cnt_rej = count($arr_util_rate_rej_type);
						
						for($i = 0; $i < $cnt_ack; $i++) {
							
							$util_rate_ack_type = $arr_util_rate_ack_type[$i];
							
							switch($util_rate_ack_type) {
								case 'N':

									break;
								
								case 'A':
																
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A'] = 0;	
									}

									if ( 0 == strlen(trim($value)) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A']++;
									}
									
									if ( $total_row == $row ) {

										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['A'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Ack Required
	
											$this->error_msg = 'Data quality warning. '  . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . '. Please ensure that this data is collected and entered into your HMIS application.' ;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;
									
								case 'O':	
									$is_adult = 'Y';
									if ('O' == $util_rate_ack_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
																
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['O']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['O'] = 0;	
									}

									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['O']++;
									}
									
									if ( $total_row == $row ) {

										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['O'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Ack Required
											$total_adults = count($validation_result["$new_file_name"]['data']['IsAdult']);
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $validation_result["$new_file_name"]['data']['AdultCount'] . ' adult ';	// $actual_num_row
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											$this->error_msg = 'Data quality warning. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . ', which exceeds acceptable levels. Please correct this in your HMIS ';
											$this->error_msg .= ' application and try the upload again.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;

								case 'B':

									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['B'] = 0;	
									}
										
										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {

											$validation_result["$new_file_name"][$field_name]['util_ack']['B']++;
											
											//$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											$this->error_msg = $field_name . ' has a value of ' . $value . ', which does not correspond to a valid response in the HMIS Data Standards.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											
										}

									break;
									
								case 'C':							
								case 'E':
									
									if ( 'C' == $util_rate_ack_type ) {
										$util_rate_ack = 15;
									} else if ( 'E' == $util_rate_ack_type ) { 
										$util_rate_ack = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['C']) ) {
											$validation_result["$new_file_name"][$field_name]['util_ack']['C'] = 0;	
									}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['C'];
										
										if ($threshold_count > $threshold) {
											$this->error_msg = 'Data quality warning.' . $threshold_count . ' of ' . $actual_num_row . ' records have missing, don\'t know, or refused responses for ';
											$this->error_msg .= $field_name . '. Please ensure that this data is collected and entered into your HMIS application.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;
									
								case 'D':
									
									break;
									
								case 'F':

									break;
									
								case 'G':
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['G']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['G'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['G']++;
									}
									if ( $total_row == $row ) {

										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['G'];

										if ($threshold_count > 0) {
											$this->error_msg = 'Records with no data in the ' . $field_name . ' field will be ignored.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
										
									break;
									
								case 'H': 
								case 'J':
								case 'L':
									break;
									
								case 'I':

									break;
									
									$acceptable_values_one = array(1,2,3,4,5,6,7,8);
									$acceptable_values_two = array(3,5,17);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['I']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['I'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) && !in_array($value, $acceptable_values_one)) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
										
									} else if ( '4' == $service_event_type && !in_array($value, $acceptable_values_two)) {

										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
									}
									if ( $total_row == $row ) {
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['I'];
										//??No Threshold?
										if ($threshold_count > 0) {
											//Ack	
											//$this->error_msg = 'There are ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records which is more than ' . $util_rate_ack . '% ack threshold limit set for this data. ';
											/* Do nothing per Molly's request on May 2nd 2013
											$this->error_msg = 'ServiceCode with a value outside of the range 1-8 where ServiceEventType is 1 or 2 and ';
											$this->error_msg .= '<br>ServiceCode with a value that is anything other than 3,5,or 17 where ServiceEventType is 4 will be ignored.';
									
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											*/
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
										
									break;
									
								case 'K':
									$service_code_range = array(1,2,3,4,5,6,7,8);
									$service_code = array_pop($validation_result["$new_file_name"]['data']['ServiceCode']);
									array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $service_code);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['K']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['K'] = 0;	
									}
									
									if ( '1' == $service_event_type && in_array($service_code, $service_code_range) &&  0 == strlen(trim($value)) ) {

										$validation_result["$new_file_name"][$field_name]['util_ack']['K']++;
										
										//$this->error_msg = 'Missing financialAssistanceAmount data where ServiceEventType is 1 and ServiceCode is 1-8. ';
										$this->error_msg = 'Data quality warning. Missing amount of TFA provided on a financial assistance service record.';
	
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
									}

									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value))) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['M']++;
										
										//$this->error_msg = 'Zip code ' . $value . ' should be 5 digit numeric value.';
										$this->error_msg = 'Data quality warning. Zip code entered for client with Personal ID ' . $PID . ' is ' . $value . '. Zip code should be 5 digit number.';
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
										
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
									}

									break;
										
								case 'P':
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);

									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {

										$validation_result["$new_file_name"][$field_name]['util_ack']['N']++;
									}
									if ( $total_row == $row ) {

										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['N'];
										//??No Threshold?
										if ($threshold_count > $threshold) {
											//Ack	
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% ack threshold limit set for this data. ';
											$this->error_msg = 'Data quality warning. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											
										}
									}
										
									break;
									
								default:
									break;		
							}
						}
						
						for($i = 0; $i < $cnt_rej; $i++) {
							
							$util_rate_rej_type = $arr_util_rate_rej_type[$i];
							
							switch($util_rate_rej_type) {
								case 'N':
									break;
								
								case 'A':

									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['A'] = 0;	
									}

									if ( 0 == strlen(trim($value)) ) {

										$validation_result["$new_file_name"][$field_name]['util_rej']['A']++;
									}
									if ( $total_row == $row ) {

										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['A'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {

											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . ', which exceeds ';
											$this->error_msg .= 'acceptable levels. Please correct this in your HMIS application and try the upload again.'; 

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
									
								case 'O':
									$is_adult = 'Y';
									if ('O' == $util_rate_rej_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
										
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['O']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['O'] = 0;	
									}
									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['O']++;
									}
									if ( $total_row == $row ) {

										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['O'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Rej
											$total_adults = count($validation_result["$new_file_name"]['data']['IsAdult']);
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $validation_result["$new_file_name"]['data']['AdultCount'] . ' adult ';	// $actual_num_row
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rejection threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
								
								case 'B':

									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['B'] = 0;	
									}

										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {
											//Validate & Count
											$validation_result["$new_file_name"][$field_name]['util_rej']['B']++;
											
											//$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											$this->error_msg = $field_name . ' has a value of ' . $value . ', which does not correspond to a valid response in the HMIS Data Standards.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}

									break;
									
								case 'C':								
								case 'E':	
									
									if ( 'C' == $util_rate_rej_type ) {
										$util_rate_rej = 15;
									} else if ( 'E' == $util_rate_rej_type ) { 
										$util_rate_rej = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['C']) ) {
												$validation_result["$new_file_name"][$field_name]['util_rej']['C'] = 0;	
										}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['C'];
										
										if ($threshold_count > $threshold) {
											
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' don\'t know or refused answer (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% reject threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records have missing, don\'t know, or refused responses for ';
											$this->error_msg .= $field_name . '. Please ensure that this data is collected and entered into your HMIS application.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									
									break;
									
								case 'D':
									
									break;
									
								case 'F':
								case 'G':
								case 'I':
								case 'K':
										
									break;
								
								case 'H':
									//$num_sesd = count($validation_result['serviceevent.csv']['data']['ServiceEventStartDate']);
									$service_event_start_date = array_pop($validation_result["$new_file_name"]['data']['ServiceEventStartDate']);
									array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $service_event_start_date);
									
									if ( 0 != strlen(trim($value)) ) {
										if ( strtotime($value) < strtotime($service_event_start_date) ) {

											$this->error_msg = 'ServiceEventEndDate ' . $value . ' cannot be prior to ServiceEventStartDate ' . $service_event_start_date . ' in serviceevent.csv ';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
								
								case 'J':								
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['J']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['J'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) &&  0 == strlen(trim($value)) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['J']++;
										
									}
									if ( $total_row == $row ) {

										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['J'];
										//??No Threshold?
										if ($threshold_count > 0) {
											//Rej	
											//$this->error_msg = 'There are ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records which is more than ' . $util_rate_rej . '% rej threshold limit set for this data. ';
											$this->error_msg = 'Missing service code where ServiceEventType is 1 or 2 is rejected.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
										
									break;
									
								case 'L':
									$entry_date = array_pop($validation_result["$new_file_name"]['data']['EntryDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['EntryDate'], $entry_date);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['L']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['L'] = 0;	
									}
									
									if ( 0 != strlen(trim($value)) ) {	
										if ( strtotime($value) < strtotime($entry_date) ) {
											$validation_result["$new_file_name"][$field_name]['util_rej']['L']++;
											$this->error_msg = 'ExitDate ' . $value . ' should be later than the EntryDate ' . $entry_date;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									
									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['M']++;
										
										//$this->error_msg = 'Zip code ' . $value . ' should be 5 digit numeric value.';
										$this->error_msg = 'Upload rejected. Zip code entered for client with Personal ID ' . $PID . ' is ' . $value . '. Zip code should be 5 digit number.';
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
										array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
										$validation_result['error']['rej_count']++;
									}
									
									break;
									
								case 'P':
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);
									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {
									
										$validation_result["$new_file_name"][$field_name]['util_rej']['N']++;
									}
									if ( $total_row == $row ) {
									
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['N'];
										//??No Threshold?
										if ($threshold_count > $threshold) {
										
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rej threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									
									break;
									
								default:
									break;		
							}
						}

						if ( 'N' == $skip_data ) {
						
							if ( 0 == strlen(trim($value)) && 'N' == $allow_null && !in_array('A', $arr_util_rate_ack_type) && !in_array('G', $arr_util_rate_ack_type) && !in_array('A', $arr_util_rate_rej_type)) {
								
								$this->error_msg = 'Upload rejected. There are blank or missing values in the ' . $field_name . ' field.';
								$this->num_error++;
								
								$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
								//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
								array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
								$validation_result['error']['error_count']++;
							
							} else {
								
								
								switch($data_type) {
									
									
									case 'V':
										
										break;
									case 'D':
										
										if(0 != strlen(trim($value))){
											$match_result = preg_match('/^\d{1,2}\/\d{1,2}\/\d{4}$/', trim($value), $date);
											
											$test_date = '1800-01-01';
											$test_date2 = '1800';
											preg_match('/(\d{4})/', trim($value), $year);
											
											if ( true == HMISValidator::validateDate($value, 'Y-m-d') && $value > $test_date ) {
											   
												
												$date_format_ok = 'Y';	
											   
											} else if (true == HMISValidator::validateDate($value, 'n/j/Y g:i:s A') && $year[0] > $test_date2) {
											
												$date_format_ok = 'Y';
												
											} else if (true == HMISValidator::validateDate($value, 'n/j/Y') && $year[0] > $test_date2) {
											
												$date_format_ok = 'Y';
												
											} else {
										
												//$this->error_msg = $value . ' is not in the valid date format for field: '. $field_name;
													$this->error_msg = 'Upload rejected. The value for ' . $field_name . ' is ' . $value . '. This is a date field and must be in the format yyyy-mm-dd where yyyy is greater than 1800.';
													
													$this->num_error++;
													
													$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
													//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
													$date_format_ok = 'N';
													array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
													$validation_result['error']['error_count']++;
											}
										
										}
										
										break;
									case 'N':
										if (!is_numeric($value) && 0 != strlen(trim($value))) {
										
											//$this->error_msg = $value . ' is not numeric for field: '. $field_name;
											$this->error_msg = 'Upload rejected. ' . $field_name . ' should contain only numbers, but the value ' . $value . ' is not numeric.';
											$this->num_error++;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											
										}
										break;
										
									case 'T':
										
										if(0 != strlen(trim($value))){
											
											
											$test_date = '1800-01-01 00:00:00';
											
											if ( true == HMISValidator::validateDate($value) && $value > $test_date ) {
											   
											   $date_format_ok = 'Y';
											   
											} else {
											   
											   	$test_date = '01-01-1800 00:00:00';
											   	$test_date2 = '1800';
											   	preg_match('/(\d{4})/', trim($value), $year);
											   	
											   	if ( true == HMISValidator::validateDate($value, 'n/j/Y g:i:s A') && $year[0] > $test_date2 ) {
											   		
											   		$date_format_ok = 'Y';	
											   		
											   	} else {
													$this->error_msg = 'Upload rejected. The value for ' . $field_name . ' is ' . $value . '. This is a datetime field and must be in the format yyyy-mm-dd hh:mm:ss where yyyy is greater than 1800.';
													$this->num_error++;
												
													$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
													//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
													array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
													$validation_result['error']['error_count']++;
													
													$date_format_ok = 'N';
												}
											}
										
										}
										
										break;
									
									case 'M':
										
										if (!HMISValidator::isCurrency($value) && 0 != strlen(trim($value))) {
											
											//$this->error_msg = $value . ' is not numeric for field: '. $field_name;
											$this->error_msg = 'Upload rejected. ' . $field_name . ' should contain only number with two decimal places, but the value ' . $value . ' is not in a valid money format.';
											$this->num_error++;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											
										}
										
										break;
										
									case 'MP':
										
										if (!HMISValidator::isCurrency_MP($value) && 0 != strlen(trim($value))) {
											
											//$this->error_msg = $value . ' is not numeric for field: '. $field_name;
											$this->error_msg = 'Upload rejected. ' . $field_name . ' should contain only non-negative number with two decimal places, but the value ' . $value . ' is not in a valid money format.';
											$this->num_error++;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											
										}
																				
										break;
									default:
										
										$this->error_msg = $data_type . ' is not defined in the db!. Please report the issue to the support group. ';	// . $value;
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
										//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg;
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
										break;
								}
								
								if ( $data_length > $field_length ) {
									
									//$this->error_msg = $field_name . ' allows ' . $field_length . '. actual length: ' . $data_length . ' value: ' . $value;
									$this->error_msg = 'Upload rejected. The maximum length for the ' . $field_name . ' field is ' . $field_length . ' characters long, but the value ';
									$this->error_msg .= $value . ' is ' . $data_length . ' characters long.';
									$this->num_error++;
									
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
									//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
									$validation_result['error']['error_count']++;
								}
							
								$pick_list_error = FALSE;
								
								if ('N' != $pick_list && !in_array('B', $arr_util_rate_ack_type) && !in_array('B', $arr_util_rate_rej_type)) {
									
									if ('Y' == $pick_list) {
										$pick_values = str_getcsv($rs->fields('pick_values'));
										
									} else if ('A' == $pick_list) {	
										$income_benefit_type = array_pop($validation_result["$new_file_name"]['data']['IncomeBenefitType']);
										
										array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $income_benefit_type);
										if ('1' == $income_benefit_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $income_benefit_type) {
											$pick_values = array(1,2,3,4,5,6,7,10,11,12,13,14);
										}
										
									} else if ('B' == $pick_list) {	
										$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
										
										array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
										if ('4' == $service_event_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,);
										} else if ('1' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,6,);
										}
									}
									if (!in_array($value, $pick_values)) {
										
										$pick_list_error = TRUE;
										//$this->error_msg = $value . ' is not in the pick list for field: ' . $field_name;
										$this->error_msg = 'Upload rejected. Values for the ' . $field_name . ' field must correspond to a response category in the HMIS Data Standards. The value ';
										$this->error_msg .= $value . ' is not valid for this field.';
										$this->num_error++;
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
										//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
									}
								}
							
							}
						} 

						$rs->movenext();
						//echo '<br>';
						
					} 
					
				}
						if ( $total_row == $row ) {
							
							$file_rej_count = count($validation_result["$new_file_name"]['rej_msg']);
							$file_ack_count =  count($validation_result["$new_file_name"]['ack_msg']);
							$file_err_count =  count($validation_result["$new_file_name"]['error_msg']);
							
							if (0 == $file_rej_count && 0 == $file_ack_count && 0 == $file_err_count) {
								$msg = $spacer . '<b><font color=blue>No issue found.</font></b><br>'; // . $new_file_name . '</font></b><br>';
								
								
								//echo $msg;
							} else {
								//echo $file_rej_count . ' - ' . $file_ack_count . ' - ' . $file_err_count;
							}
						} else {
							
							$actual_row = $total_row - $row;
							//$msg = $spacer . '<b><font color=blue>No issue found. [' . $actual_row . ' line-break(s) skipped.]</font></b><br>'; // . $new_file_name . '</font></b><br>';
							$msg = $spacer . '<b><font color=blue>No issue found.</font></b><br>'; // . $new_file_name . '</font></b><br>';
							
						}
				
				fclose($handle);
				
			} else {
				
				$msg = $spacer . 'Read file failed: ' . $tmp_dir_unzip . $file_name;
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;
			}
			
			$rs->Close();
			
			return $validation_result;
			
		}	
		
		
		
		function validate ($file_name, $tmp_dir_unzip, $validation_result, $format_version) {
			
			
			$new_file_name =  strtolower (str_replace('_', '', $file_name));
			$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
			global $file_upload_report;
			
			
			$msg = '<b>' . $file_name . '</b> ';
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
			
			if(!HMISValidator::is_file_name_valid($new_file_name)) {

				
				/*
				$cur_err_cnt = $validation_result['error']['error_count'];
				$validation_result['error']["$cur_err_cnt"]['error_msg'] = $validation_result['error']['error_msg'] . $this->error_msg;
				$validation_result['error']['error_count']++;
				*/
				
				$this->error_msg = $new_file_name . ' does not match any of the expected HMIS CSV format file names.';
				$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error');
				
				array_push($validation_result['error']['error_msg'], $this->error_msg);
				$validation_result['error']['error_count']++;
				
				//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg;
				
			} else {
				
				//echo ' is a valid file name. ';
				//$validation_result['file_name']["$file_name"]['detail'] = $file_name; //delete after testing
			}
			
			global $db;
			$PID = '';
			$column_error = FALSE;
			
			$sql = 'SELECT [val_type]     
				FROM tb_SSVF_program
				WHERE [program_id] = ' . $_SESSION['program_id'];
			$rs = $db->Execute($sql) or die ("<br>Select validation type failed. ");
			$val_type = $rs->fields('val_type');
			
			//$sql = 'Select * From FileFormat Where format_name = \'' . $new_file_name . '\' Order By format_order';			
			$sql = 'SELECT ff.[format_id]
				,ff.[format_order]
				,ff.[format_name]
				,ff.[field_name]
				,ff.[data_type]
				,ff.[allow_null]
				,ff.[pick_list]
				,ff.[field_length]
				,ff.[skip_data]
				,ff.[util_rate_ack_type]
				,ff.[util_rate_ack]
				,ff.[util_rate_rej_type]
				,ff.[util_rate_rej]
				,ff.[pick_values]
				,hct.[program_id]
				,hct.[util_rate_ack_type] as hct_util_rate_ack_type
				,hct.[util_rate_ack] as hct_util_rate_ack
				,hct.[util_rate_rej_type] as hct_util_rate_rej_type
				,hct.[util_rate_rej] as hct_util_rate_rej
			FROM FileFormat ff left join 
				(Select * from HMIS_Custom_Threshold Where program_id = ' . $_SESSION['program_id'] . ') hct
				On ff.format_id = hct.format_id
			Where ff.format_name = \'' . $new_file_name . '\' and ff.format_version = ' . $format_version . '
			order by ff.format_order';
			
			$rs = $db->Execute($sql) or die ("<br>$sql <br>Select file failed");
			$record_count = $rs->RecordCount();
			
			
			if (($handle = fopen($tmp_dir_unzip . $file_name, "r")) !== FALSE) {
				$row = 0;
				$total_row = count(file($tmp_dir_unzip . $file_name));
				$actual_num_row = $total_row - 1;

				$msg = '['. $total_row . ' rows found in the file.] <br>';
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;
			
				while (($data = fgetcsv($handle)) !== FALSE) {
					$num = count($data);
					
					if ($num != $record_count && FALSE == $column_error){
						//Error
						$this->error_msg = 'Unable to process.  The structure of this file is incorrect.  There should be ' . $record_count . ' columns but the file contains ' . $num . ' columns.';	//' columns but row ' . $row . ' has ' . $num . ' columns.';
						$this->num_error++;
						
						$column_error = TRUE;
						/*
						$cur_err_cnt = $validation_result['error']['error_count'];
						$validation_result['error']["$cur_err_cnt"]['error_msg'] = $validation_result['error']['error_msg'] . $this->error_msg;
						$validation_result['error']['error_count']++;
						*/
						
						
						$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error');
						
						array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
						$validation_result['error']['error_count']++;
						//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg;
						
						//$validation_result['record_count'] =  $this->error_msg;
					}
					
					$row++;
					if (1 == $row) {
						
						continue;
					}
					
					
					$rs->movefirst();
					
					for ($c=0; $c < $num; $c++) {
						
						$col_num = $c + 1;
						$value = trim(scrub_white_list($data[$c], 'DATA'));
						$data_length = strlen(trim($value));
						
						$field_name = $rs->fields('field_name');
						$data_type = $rs->fields('data_type');
						$allow_null = $rs->fields('allow_null');
						$pick_list = $rs->fields('pick_list');
						$field_length = $rs->fields('field_length');
						$skip_data = $rs->fields('skip_data');
						
						if ( 1 == $val_type && !is_Null($rs->fields('program_id'))) {
							$arr_util_rate_ack_type = str_getcsv($rs->fields('hct_util_rate_ack_type'));
							$util_rate_ack = $rs->fields('hct_util_rate_ack');
							$arr_util_rate_rej_type = str_getcsv($rs->fields('hct_util_rate_rej_type'));
							$util_rate_rej = $rs->fields('hct_util_rate_rej');
							
							
						} else {
							$arr_util_rate_ack_type = str_getcsv($rs->fields('util_rate_ack_type'));
							$util_rate_ack = $rs->fields('util_rate_ack');
							$arr_util_rate_rej_type = str_getcsv($rs->fields('util_rate_rej_type'));
							$util_rate_rej = $rs->fields('util_rate_rej');
						}
						
						if ('export.csv' == $new_file_name) {
							
							if ('ExportIDStr' == $field_name) {
								$validation_result["$new_file_name"]['data']['ExportIDStr'] = $value;
							} else if ('ExportDate' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportDate'] = $value;
							} else if ('ExportPeriodBegin' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportPeriodBegin'] = $value;
								
								$date_limit1 = strtotime('10/01/2011');
								$date_limit2 = strtotime('10/01/2012');
								$date_limit3 = strtotime('10/01/2013');
								
								$begin_date = strtotime($value);
								//echo '<br>grant id: ' . $_SESSION['grant_id'] . ' begin: ' . $begin_date . '<br>';
								
								if ( 104 >= $_SESSION['grant_id'] && $date_limit1 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2011.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									
								} else if ( 104 < $_SESSION['grant_id'] && $_SESSION['grant_id'] < 200 && $date_limit2 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2012.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								} else if ( 200 <= $_SESSION['grant_id'] && $date_limit3 < $begin_date ) {
									$this->error_msg = 'Unable to process.  Data is incomplete.  The start of the export period for this upload is ' . $value . '. The start of the export period must be on or before 10/1/2013.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
								
								
							} else if ('ExportPeriodEnd' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportPeriodEnd'] = $value;
								if ($validation_result["$new_file_name"]['data']['ExportDate'] != $value) {
									//Rejection
									$this->error_msg = 'Unable to process.  Data is incomplete.  The end of the export period for this upload is ' . $value . ' but the date of the export is ' . $validation_result["$new_file_name"]['data']['ExportDate'] . ' Please use the date that the export is generated as the end date.';
									/*
									$cur_err_cnt = $validation_result["$new_file_name"]['rej_count'];
									$validation_result["$new_file_name"]["$cur_err_cnt"]['rej_msg'] = $this->error_msg;
									$validation_result["$new_file_name"]['rej_count']++;
									*/
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								}
								
							} else if ('ExportHashing' == $field_name){
								
								if ( (0 != strlen(trim($value))) && '0' != $value ) {
									//Rejection
									$this->error_msg = 'Unable to process.  This file appears to contain hashed or encrypted data.  All data uploaded to the Repository must be unencrypted. (ExportHashing = ' . $value . ')';
									/*
									$cur_err_cnt = $validation_result["$new_file_name"]['rej_count'];
									$validation_result["$new_file_name"]["$cur_err_cnt"]['rej_msg'] = $this->error_msg;
									$validation_result["$new_file_name"]['rej_count']++;
									*/
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								}
							} else if ('DeltaOrRefresh' == $field_name){
								
								
								if ( (0 != strlen(trim($value))) && '1' != $value ) {
									//Rejection
									$this->error_msg = 'Unable to process.  The export must include all records.  (DeltaOrRefresh = ' . $value . ')';
									/*
									$cur_err_cnt = $validation_result["$new_file_name"]['rej_count'];
									$validation_result["$new_file_name"]["$cur_err_cnt"]['rej_msg'] = $this->error_msg;
									$validation_result["$new_file_name"]['rej_count']++;
									*/
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
									//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
								}
							} 
						} else {
							
							 if ( 'ExportIDStr' == $field_name && ($value != $validation_result['export.csv']['data']['ExportIDStr']) ) {
								//Rejection
								/*
								$cur_err_cnt = $validation_result["$new_file_name"]['rej_count'];
								$validation_result["$new_file_name"]["$cur_err_cnt"]['rej_msg'] = $this->error_msg;
								$validation_result["$new_file_name"]['rej_count']++;
								*/
								$this->error_msg = 'Unable to process.  This file appears to include records from more than one export.  The Repository can only process data from a single export.  (ExportIDStr in file: ' . $value . '. ExportIDStr in Export.csv: ' . $validation_result['export.csv']['data']['ExportIDStr'] . ')';
								$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
								//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
								$validation_result['error']['rej_count']++;
							}
						}
						
						
						if ('agencyprogram.csv' == $new_file_name) {
							
							if ('OrganizationID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['OrganizationID'], $value);
								
							} else if ('ProgramID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['ProgramID'], $value);
								
							} else if ('DateCreated' == $field_name && strtotime($value) > strtotime($validation_result['export.csv']['data']['ExportPeriodBegin'])){
								
								
								//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
								
							}
						}
						
						if ('client.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								$PID = $value;
								
								
							} else if ( 'DateOfBirth' == $field_name ) {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
								$new_key = 'pid_' . $PID;
								$_SESSION["$new_key"] = $value;
								//echo 'session pid = ' . $_SESSION["$PID"] . '<br>';
								array_push($validation_result["$new_file_name"]['data']['DateOfBirth'], $value);
								
								//per Molly 06/27/2013
								if (!preg_match('/^\d{1,2}\/\d{1,2}\/\d{4}$/', trim($value)) || 0 == strlen(trim($value))) { 
									
									$this->error_msg = 'Data quality warning. Missing or invalid date of birth ' . $dob . ' for client with Personal ID ' . $PID . '. Date of birth data must be collected for 100% of clients, including household members.  Error checking will assume the client is an adult.';

									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);	//, $row, $PID); Comment Out Per Molly's request on May 2nd 2013
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg); 
									$validation_result['error']['ack_count']++;
								}
									
								
							} else {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
							}
							/* handle this below in the treshold validation block
								else if ( 'LegalFirstName' == $field_name && (0 != strlen(trim($value))) ) {
								//array_push($validation_result["$new_file_name"]['missing_LegalFirstName'], $this->error_msg);
								//$validation_result["$new_file_name"]['missing_LegalFirstName']++;
							}
							*/
							
						}
						
						if ('serviceevent.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								$PID = $value;
								$validation_result['count']['service_records']++;
						
							} else {
							
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
							}
							
							if ( 'ServiceEventStartDate' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $value);
								
							} else if ( 'ServiceEventType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $value);
								
							} else if ( 'ServiceCode' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $value);
								
							}

						}
						
						
						if ('programparticipation.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								$PID = $value;
								
							} else if ( 'EntryDate' == $field_name ) {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
								
								array_push($validation_result["$new_file_name"]['data']['EntryDate'], $value);
								$ENTR_DATE = $value;
								
								$is_adult = 'N';
								$new_key = 'pid_' . $PID;
								
								if ( 0 != strlen(trim($ENTR_DATE)) ) {
									//$validation_result['count']['program_entries_records']++;
									array_push($validation_result['count']['program_entries_records'], $PID.trim($ENTR_DATE));
								}
								
								if ( !isset($_SESSION["$new_key"]) ) {
									
									$this->error_msg = 'Data quality warning.  There is no matching client record for Personal ID ' . $PID . ' (' . $value . '). Records in this file with no corresponding client record will be ignored for reporting purposes.';
									$this->num_error++;
									
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
									
									array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
									$validation_result['error']['error_count']++;
									
								} else {
									$dob = $_SESSION["$new_key"];
									
									if (!preg_match('/^\d{1,2}\/\d{1,2}\/\d{4}$/', trim($dob)) || 0 == strlen(trim($dob))) { 
										
										$is_adult = 'Y';
										
										//$validation_result['count']['missing_DOB_records']++;
										array_push($validation_result['count']['missing_DOB_records'], $PID);	//moved down from the DOB code above
									
										
									} else {
										//echo $row . '. $dob: ' . $dob . ', $sub_18_years: ' . $value . '<br>';
										$dob_18_years = date('Y', strtotime($dob)) + 18;
										$var_entry_date = strtotime($value);
										
										$var_18_years  = mktime(0, 0, 0, date('m', strtotime($dob)),   date('d', strtotime($dob)),   $dob_18_years);
										
										if ($var_18_years <= $var_entry_date) {
											$is_adult = 'Y';
											$validation_result['programparticipation.csv']['data']['AdultCount']++;
											//$validation_result['count']['adult_records']++;
											array_push($validation_result['count']['adult_records'], $PID);
										} else {
											//$validation_result['count']['child_records']++;
											array_push($validation_result['count']['child_records'], $PID);
										}
										
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									
									}
								}
								
							} else if ( 'ExitDate' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ExitDate'], $value);
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
								
								if ( 0 != strlen(trim($value)) ) {
									//$validation_result['count']['program_exits_records']++;
									array_push($validation_result['count']['program_exits_records'], $PID.trim($value));
								}
							}
							
						}
						
						if ('incomebenefits.csv' == $new_file_name) {
							
							if ( 'IncomeBenefitType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $value);
								
							}
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								$PID = $value;
								
							} else {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
							}

						}
						
						
						if ('clienthistorical.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								$PID = $value;
								
							} else {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								//put the value back to the array
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
							}
							
						}
						
						$id_check_file_names = array('clienthistorical.csv', 'incomebenefits.csv', 'serviceevent.csv', 'programparticipation.csv');
						
						if (in_array($new_file_name, $id_check_file_names)) {	
							
							if ( 'PersonalIdentificationNumber' == $field_name ){
								
								if (!in_array($value, $validation_result['client.csv']['data']['PersonalIdentificationNumber'])) {
									//Ack
									$this->error_msg = 'Data quality warning.  There is no matching client record for Personal ID <b>' . $value . '</b>. Records in this file with no corresponding client record will be ignored for reporting purposes.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
								
							} else if ('OrganizationID' == $field_name){
	
								if (!in_array($value, $validation_result['agencyprogram.csv']['data']['OrganizationID'])) {
									//Ack
									$this->error_msg = 'Data quality warning.  There is no matching record for an organization with the identifier ' . $value . '. Records in this file with no corresponding organization record will be ignored for reporting purposes.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
								
							} else if ('ProgramID' == $field_name){

								if (!in_array($value, $validation_result['agencyprogram.csv']['data']['ProgramID'])) {
									//Ack
									$this->error_msg = 'Data quality warning.  There is no matching record for a program with the identifier ' . $value . '.';
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
									//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
								}
							}
						}
						
						$cnt_ack = count($arr_util_rate_ack_type);
						$cnt_rej = count($arr_util_rate_rej_type);
						
						for($i = 0; $i < $cnt_ack; $i++) {
							
							$util_rate_ack_type = $arr_util_rate_ack_type[$i];
							
							switch($util_rate_ack_type) {
								case 'N':
								
									break;
								
								case 'A':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A']++;
									}
									
									if ( $total_row == $row ) {
									
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['A'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Ack Required
	
											$this->error_msg = 'Data quality warning. '  . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . '. Please ensure that this data is collected and entered into your HMIS application.' ;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;
									
								case 'O':
									$is_adult = 'Y';
									if ('O' == $util_rate_ack_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										//put the value back to the array
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['O']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['O'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['O']++;
									}
									
									if ( $total_row == $row ) {
									
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['O'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Ack Required
											$total_adults = count($validation_result["$new_file_name"]['data']['IsAdult']);
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $validation_result["$new_file_name"]['data']['AdultCount'] . ' adult ';	// $actual_num_row
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											$this->error_msg = 'Data quality warning. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . ', which exceeds acceptable levels. Please correct this in your HMIS ';
											$this->error_msg .= ' application and try the upload again.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;

								case 'B':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['B'] = 0;	
									}
									
										
										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {
											
											$validation_result["$new_file_name"][$field_name]['util_ack']['B']++;
											
											//$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											$this->error_msg = $field_name . ' has a value of ' . $value . ', which does not correspond to a valid response in the HMIS Data Standards.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											
										}
										
									break;
									
								case 'C':								
								case 'E':	
									
									if ( 'C' == $util_rate_ack_type ) {
										$util_rate_ack = 15;
									} else if ( 'E' == $util_rate_ack_type ) { 
										$util_rate_ack = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['C']) ) {
											$validation_result["$new_file_name"][$field_name]['util_ack']['C'] = 0;	
									}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['C'];
										
										if ($threshold_count > $threshold) {
											$this->error_msg = 'Data quality warning.' . $threshold_count . ' of ' . $actual_num_row . ' records have missing, don\'t know, or refused responses for ';
											$this->error_msg .= $field_name . '. Please ensure that this data is collected and entered into your HMIS application.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
									
									break;
									
								case 'D':
									
									break;
									
								case 'F':

									break;
									
									
								case 'G':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['G']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['G'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['G']++;
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['G'];
										
										if ($threshold_count > 0) {
											//Ack	
											//$this->error_msg = 'There are ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records which is more than ' . $util_rate_ack . '% ack threshold limit set for this data. ';
											$this->error_msg = 'Records with no data in the ' . $field_name . ' field will be ignored.';
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
										}
									}
										
									break;
									
								case 'H': 
								case 'J':
								case 'L':
									
									break;
									
								case 'I':

									break; 
									
									$acceptable_values_one = array(1,2,3,4,5,6,7,8);
									$acceptable_values_two = array(3,5,17);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['I']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['I'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) && !in_array($value, $acceptable_values_one)) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
										
									} else if ( '4' == $service_event_type && !in_array($value, $acceptable_values_two)) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['I'];
										//??No Threshold?
										if ($threshold_count > 0) {
											
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
										
									break;
									
								case 'K':
									$service_code_range = array(1,2,3,4,5,6,7,8);
									$service_code = array_pop($validation_result["$new_file_name"]['data']['ServiceCode']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $service_code);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['K']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['K'] = 0;	
									}
									
									if ( '1' == $service_event_type && in_array($service_code, $service_code_range) &&  0 == strlen(trim($value)) ) {
										//Validate & Count
										$validation_result["$new_file_name"][$field_name]['util_ack']['K']++;
										
										//$this->error_msg = 'Missing financialAssistanceAmount data where ServiceEventType is 1 and ServiceCode is 1-8. ';
										$this->error_msg = 'Data quality warning. Missing amount of TFA provided on a financial assistance service record.';
	
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
									}
										
									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value))) {
										//Validate & Count
										$validation_result["$new_file_name"][$field_name]['util_ack']['M']++;
										
										//$this->error_msg = 'Zip code ' . $value . ' should be 5 digit numeric value.';
										$this->error_msg = 'Data quality warning. Zip code entered for client with Personal ID ' . $PID . ' is ' . $value . '. Zip code should be 5 digit number.';
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row, $PID);
										
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
									}
										
									break;
										
								case 'P':
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {
										//Validate & Count
										$validation_result["$new_file_name"][$field_name]['util_ack']['N']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['N'];
										
										if ($threshold_count > $threshold) {
											//Ack	
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% ack threshold limit set for this data. ';
											$this->error_msg = 'Data quality warning. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											//echo $ack_err_msg . $validation_result['error']['ack_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											
										}
									}
										
									break;
									
								default:
									
									break;		
							}
						}
						
						
						for($i = 0; $i < $cnt_rej; $i++) {
							
							$util_rate_rej_type = $arr_util_rate_rej_type[$i];
							
							switch($util_rate_rej_type) {
								case 'N':
									
									break;
								
								case 'A':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['A'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['A']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['A'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Rej
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;	// 
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rejection threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name . ', which exceeds ';
											$this->error_msg .= 'acceptable levels. Please correct this in your HMIS application and try the upload again.'; 

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
									
								case 'O':
									$is_adult = 'Y';
									if ('O' == $util_rate_rej_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										//put the value back to the array
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
										
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['O']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['O'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['O']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['O'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											//Rej
											$total_adults = count($validation_result["$new_file_name"]['data']['IsAdult']);
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $validation_result["$new_file_name"]['data']['AdultCount'] . ' adult ';	// $actual_num_row
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rejection threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
								
								case 'B':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['B'] = 0;	
									}
									
										
										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {
											//Validate & Count
											$validation_result["$new_file_name"][$field_name]['util_rej']['B']++;
											
											//$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											$this->error_msg = $field_name . ' has a value of ' . $value . ', which does not correspond to a valid response in the HMIS Data Standards.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
										
									break;
									
								case 'C':							
								case 'E':
									
									if ( 'C' == $util_rate_rej_type ) {
										$util_rate_rej = 15;
									} else if ( 'E' == $util_rate_rej_type ) { 
										$util_rate_rej = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['C']) ) {
												$validation_result["$new_file_name"][$field_name]['util_rej']['C'] = 0;	
										}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['C'];
										
										if ($threshold_count > $threshold) {
											//Rej Required
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' don\'t know or refused answer (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% reject threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records have missing, don\'t know, or refused responses for ';
											$this->error_msg .= $field_name . '. Please ensure that this data is collected and entered into your HMIS application.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									
									break;
									
								case 'D':
									
									break;
									
								case 'F':
								case 'G':
								case 'I':
								case 'K':
										
									break;
								
								case 'H':	
									$service_event_start_date = array_pop($validation_result["$new_file_name"]['data']['ServiceEventStartDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $service_event_start_date);
									
									if ( 0 != strlen(trim($value)) ) {	
										if ( strtotime($value) < strtotime($service_event_start_date) ) {
											
											$this->error_msg = 'ServiceEventEndDate ' . $value . ' cannot be prior to ServiceEventStartDate ' . $service_event_start_date . ' in serviceevent.csv ';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									break;
								
								case 'J':								
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['J']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['J'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) &&  0 == strlen(trim($value)) ) {
										//Validate & Count
										$validation_result["$new_file_name"][$field_name]['util_rej']['J']++;
										
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['J'];
										//??No Threshold?
										if ($threshold_count > 0) {
											$this->error_msg = 'Missing service code where ServiceEventType is 1 or 2 is rejected.';
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
										
									break;
									
								case 'L':
									$entry_date = array_pop($validation_result["$new_file_name"]['data']['EntryDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['EntryDate'], $entry_date);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['L']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['L'] = 0;	
									}
									
									if ( 0 != strlen(trim($value)) ) {
										if ( strtotime($value) < strtotime($entry_date) ) {
											
											$validation_result["$new_file_name"][$field_name]['util_rej']['L']++;
											$this->error_msg = 'ExitDate ' . $value . ' should be later than the EntryDate ' . $entry_date;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
										
									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['M']++;
										
										$this->error_msg = 'Upload rejected. Zip code entered for client with Personal ID ' . $PID . ' is ' . $value . '. Zip code should be 5 digit number.';
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row, $PID);
										array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
										$validation_result['error']['rej_count']++;
									}
																			
									break;
									
								case 'P':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {
										//Validate & Count
										$validation_result["$new_file_name"][$field_name]['util_rej']['N']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['N'];
										
										if ($threshold_count > $threshold) {
											
											//$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rej threshold limit set for this data. ';
											$this->error_msg = 'Upload rejected. ' . $threshold_count . ' of ' . $actual_num_row . ' records are missing values for ' . $field_name;
											$this->error_msg .= ', which exceeds acceptable levels. Please correct this in your HMIS application and try the upload again.';

											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
										}
									}
									
									break;
									
								default:
									
									break;		
							}
						}
						
						
						if ( 'N' == $skip_data ) {
							
								
							if ( 0 == strlen(trim($value)) && 'N' == $allow_null && !in_array('A', $arr_util_rate_ack_type) && !in_array('G', $arr_util_rate_ack_type) && !in_array('A', $arr_util_rate_rej_type)) {
								
								//$this->error_msg = $field_name . ' doesn\'t allow null';
								$this->error_msg = 'Upload rejected. There are blank or missing values in the ' . $field_name . ' field.';
								$this->num_error++;
								
								$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
								//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
								array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
								$validation_result['error']['error_count']++;
							
							} else {
								
								switch($data_type) {
									case 'V':
										
										break;
									case 'D':
										
										if(0 != strlen(trim($value))){
											$match_result = preg_match('/^\d{1,2}\/\d{1,2}\/\d{4}$/', trim($value), $date);
											if(1 == $match_result) {
												$datebit = explode('/', $date[0]);
										
												if (!checkdate($datebit[0] , $datebit[1] , $datebit[2])) {
													//error
													//$this->error_msg = $value . ' is not in the valid date format for field: '. $field_name;
													$this->error_msg = 'Upload rejected. ' . $field_name . ' is a date field, but the value ' . $value . ' does not appear to be a date.';
													$this->num_error++;
												
													$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
													//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
													array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
													$validation_result['error']['error_count']++;
													
													$date_format_ok = 'N';
												} else {
													$date_format_ok = 'Y';	
												}
											} else {
												
													//$this->error_msg = $value . ' is not in the valid date format for field: '. $field_name;
													$this->error_msg = 'Upload rejected. ' . $field_name . ' is a date field, but the value ' . $value . ' does not appear to be a date.';
													
													$this->num_error++;
													
													$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
													//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
													$date_format_ok = 'N';
													array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
													$validation_result['error']['error_count']++;
											}
										
										}
										
										break;
									case 'N':
										if (!is_numeric($value) && 0 != strlen(trim($value))) {
											
											$this->error_msg = 'Upload rejected. ' . $field_name . ' should contain only numbers, but the value ' . $value . ' is not numeric.';
											$this->num_error++;
											
											$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											
										}
										break;
										
									case 'T':
										
										break;
										
									default:
										
										$this->error_msg = $data_type . ' is not defined in the db. Please report the issue to the support group. ';	// . $value;
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
										//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg;
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
										break;
								}
								
								
								if ( $data_length > $field_length ) {
									//error
									//$this->error_msg = $field_name . ' allows ' . $field_length . '. actual length: ' . $data_length . ' value: ' . $value;
									$this->error_msg = 'Upload rejected. The maximum length for the ' . $field_name . ' field is ' . $field_length . ' characters long, but the value ';
									$this->error_msg .= $value . ' is ' . $data_length . ' characters long.';
									$this->num_error++;
									
									$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
									//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
									array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
									$validation_result['error']['error_count']++;
								}
							
								$pick_list_error = FALSE;
								
								if ('N' != $pick_list && !in_array('B', $arr_util_rate_ack_type) && !in_array('B', $arr_util_rate_rej_type)) {
									
									if ('Y' == $pick_list) {
										$pick_values = str_getcsv($rs->fields('pick_values'));
										
									} else if ('A' == $pick_list) {	
										$income_benefit_type = array_pop($validation_result["$new_file_name"]['data']['IncomeBenefitType']);
										//put the value back to the array
										array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $income_benefit_type);
										if ('1' == $income_benefit_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $income_benefit_type) {
											$pick_values = array(1,2,3,4,5,6,7,10,11,12,13,14);
										}
										
									} else if ('B' == $pick_list) {	
										$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
										//put the value back to the array
										array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
										if ('4' == $service_event_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,);
										} else if ('1' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,6,);
										}
									}
									if (!in_array($value, $pick_values)) {
										//error
										$pick_list_error = TRUE;
										//$this->error_msg = $value . ' is not in the pick list for field: ' . $field_name;
										$this->error_msg = 'Upload rejected. Values for the ' . $field_name . ' field must correspond to a response category in the HMIS Data Standards. The value ';
										$this->error_msg .= $value . ' is not valid for this field.';
										$this->num_error++;
										
										$this->error_msg = HMISValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row, $PID);
										//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
									}
								}
							
							}
						} 

						$rs->movenext();
						
						
					} 
					
				}
						if ( $total_row == $row ) {
							
							$file_rej_count = count($validation_result["$new_file_name"]['rej_msg']);
							$file_ack_count =  count($validation_result["$new_file_name"]['ack_msg']);
							$file_err_count =  count($validation_result["$new_file_name"]['error_msg']);
							
							if (0 == $file_rej_count && 0 == $file_ack_count && 0 == $file_err_count) {
								$msg = $spacer . '<b><font color=blue>No issue found.</font></b><br>'; // . $new_file_name . '</font></b><br>';
								
							} else {
								
							}
						} else {
							
							$actual_row = $total_row - $row;
							//$msg = $spacer . '<b><font color=blue>No issue found. [' . $actual_row . ' line-break(s) skipped.]</font></b><br>'; // . $new_file_name . '</font></b><br>';
							$msg = $spacer . '<b><font color=blue>No issue found.</font></b><br>'; // . $new_file_name . '</font></b><br>';
							
						}
				
				fclose($handle);
				
			} else {
				
				$msg = $spacer . 'Read file failed: ' . $tmp_dir_unzip . $file_name;
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;
			}
			
			$rs->Close();
			
			return $validation_result;
			
		}	
		
		function display_error($msg, $count, $type, $row = -1, $pid = '', $entry_date = '', $assessment_date = '', $service_event_start_date = '') {
			 
			global $file_upload_report;
			$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
			$data_info = '';
			$pid_msg = '';
			
			if ('error' == $type) {
				$head_err_msg = '';	//'<b><font color = "red">File Error #';
			} else if ('ack' == $type) {
				$head_err_msg = '';	//'<b><font color = "green">Acknowledgement required #';
			} else if ('rej' == $type) { 
				$head_err_msg = '';	//'<b><font color = "red">Rejected #';
			} else {
				$head_err_msg = '';	//'<b><font color = "red">System Error #';	
			}
			if ('' != $pid) {
				$pid_msg = ' pid: ' . $pid;	
			}
			if ('' != $entry_date) {
				$entry_date_msg = ' entry date: ' . $entry_date;	
			}
			if ('' != $assessment_date) {
				$assessment_date_msg = ' assessment date: ' . $assessment_date;	
			}
			if ('' != $service_event_start_date) {
				$service_event_start_date_msg = ' service event start date: ' . $service_event_start_date;	
			}
			if ( -1 < $row ) {
				$data_info = '<br> <b>(row #' . $row . $pid_msg . $entry_date . $assessment_date . $service_event_start_date . ')</b>';
			}
			
			$msg = $msg . $data_info;
			
			return $msg;
			
		}
		
		function is_file_name_valid ($file_name) {
			
			return in_array($file_name, $this->valid_file_names);
		}
		
		function validateDate($date, $format = 'Y-m-d H:i:s'){
		    $d = DateTime::createFromFormat($format, $date);
		    return $d && $d->format($format) == $date;
		}
		
		function isCurrency($number){
		  return preg_match("/^-?[0-9]+(?:\.[0-9]{1,2})?$/", $number);
		}
		
		function isCurrency_MP($number){
		  return preg_match("/^[0-9]+(?:\.[0-9]{1,2})?$/", $number);
		}
		
		function validate_regex($value,$option){
			
			switch($option) {
				case 'phone':
					$result = preg_match("/^[2-9][0-9]{2}[2-9][0-9]{2}[0-9]{4}$/", $value);

					break;
					
				case 'ext':
					$result = preg_match("/^[0-9]{1,5}$/", $value);

					break;
					
				case 'email':
					$result = preg_match("/^(([A-Za-z0-9]+_+)|([A-Za-z0-9]+\-+)|([A-Za-z0-9]+\.+)|([A-Za-z0-9]+\++))*[A-Za-z0-9]+@((\w+\-+)|(\w+\.))*\w{1,63}\.[a-zA-Z]{2,6}$/", $value);
					break;
					
				case 'coccode':
					$result = preg_match("/^[a-zA-Z]{2}-[0-9]{3}$/", $value);
					break;
					
				case 'ssn':
					$result = preg_match("/^[0-9xX]{9}$/", $value);
					break;	
					
				case 'YES':
					$result = preg_match("/^19[2-9]\d|20[0-1]\d$/", $value);
					break;	
					
				case 'state':
					$result = preg_match("/^[a-zA-Z]{2}$/", $value);
					break;	
					
				case 'zip':
					$result = preg_match("/^[0-9]{5}$/", $value);
					break;		
					
				default:
					break;
			}
			
		  return $result;
		}

	}
	
?>
