<?
	require_once('libs/functions.php');
	require_once('libs/_autoload.php');
	include('../init.php');
	
	global $file_upload_report;

if (checklogin($userID, "menu.php")) {
	print_header();
	echo '
		<h1 align="center">Upload CSV FY15 Data<!-- END: PAGE TITLE --></h1>
		<CENTER><A HREF="/hmis/">CSV Upload FY15 Data</A> | <A HREF="/menu.php">Repository Home</A></CENTER>
		<HR><br><br>
	';

	$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
	$program_id = scrub_sql(scrub_white_list($_REQUEST['program_id'], 'NUMBERONLY'), 9);
	$_SESSION['program_id'] = $program_id;
	$dataset_id = scrub_sql(scrub_white_list($_REQUEST['dataset_id'], 'NUMBERONLY'), 1);
	$format_version = scrub_sql(scrub_white_list($_REQUEST['format_version'], 'NUMBERONLY'), 1);
	$option = scrub_sql(scrub_white_list($_REQUEST['option'], 'ALPHAONLY'), 15);

	if ( ($_FILES["file"]["size"] < FILE_SIZE_LIMIT) && ($_FILES["file"]["size"] > 0) && ( 128 > strlen($_FILES['file']['name']))) {
	
		if ($_FILES["file"]["error"] > 0) {
			$msg = "Return Code: " . $_FILES["file"]["error"] . "<br />";
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
    		} else {

			$file_name = scrub_white_list($_FILES['file']['name'], 'FILENAME');
			$tmp_name  = $_FILES['file']['tmp_name'];
			$file_size = $_FILES['file']['size'];
			$file_type = $_FILES['file']['type'];
			if ( !isset($_SESSION['uniq_id']) ) { 

				$_SESSION['uniq_id'] = uniqid();	
				$uniqid = $_SESSION['uniq_id'];
			}
			
			$_SESSION['zip_file'] = $file_name;

			if ('Yes' == $process_file) {

				$tmp_work_dir = $file_upload_path . $_SESSION['uniq_id'] . '/';
			} else {
				$tmp_work_dir = $file_upload_path;
			}
			$tmp_work_unzip_dir = $tmp_work_dir . 'unzip/';
			
			$sql = 'Select program_name, grant_id From tb_SSVF_program Where program_id = ' . $program_id;
			$rs = $db->Execute($sql) or die ("<br>SQL failed");	
			$program_name = $rs->fields('program_name');
			//12/07/2012 File Validation update
			$grant_id = $rs->fields('grant_id');
			$_SESSION['grant_id'] = $grant_id;
			
			$sql = 'Select username, email From tb_user Where user_id = ' . $userID;
			$rs = $db->Execute($sql) or die ("<br>SQL failed");	
			$user_name = $rs->fields('username');
			$user_email = $rs->fields('email');
			
			$msg = '
				<table width=755 align="center">
				<tr class="va-section-header" width="550">
					<td colspan=2>&nbsp; </td>
				</tr>
				<tr>
					<td>
			';
			$msg = $msg . '<br><b>Step 1. File Upload </b><br><br>';
			$msg = $msg . 'Program name: ' . $program_name . '<br />';
			$msg = $msg . 'User name: ' . $user_name . '<br />';
			$msg = $msg . 'User email: ' . $user_email . '<br />';
			$msg = $msg . 'File name: ' . $file_name . '<br />';
			$msg = $msg . 'File type: ' . $file_type . '<br />';
			$msg = $msg . 'File size: ' . ($file_size / 1024) . ' Kb<br />';
			$msg = $msg . 'Processing Option: ' . $option . '<br />';
			
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
			
			
			if ( 'Yes' == $process_file && file_exists($tmp_work_dir . $file_name)) {
			
				$msg = $file_name . ' <font color="red">There is already a file you uploaded in the system. Since we detected a new upload, we\'ve deleted previously uploaded file. <b>Please try uploading the file again</b>.</font>';	
				
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;

			} else if ('Yes' == $process_file && !mkdir($tmp_work_dir, $tmp_dir_perm)) {
				$msg = 'Creating upload directory failed. Please contact HMIS support.'; 
				$file_upload_report = $file_upload_report . $msg;
				echo $msg;

			} else {

				if ('Yes' == $process_file) {
					move_uploaded_file($tmp_name, $tmp_work_dir . $file_name);
				}
				
				$zip = new ZipArchive;
				if ($zip->open($tmp_work_dir . $file_name) === TRUE) {
					
					if (!mkdir($tmp_work_unzip_dir, 0700)) {
                                		$msg = '<br> Creating work directory failed. <br>';	
										$file_upload_report = $file_upload_report . $msg;
										echo $msg;
                        		}
                        		
                        		$msg = '<br><b>Step 2. Unzip </b><br>';
                        		if ('Yes' == $process_file) {
                        			$zip->extractTo($tmp_work_unzip_dir);
                        		}
					$msg = $msg . ' <br>Unzip successful<br>';
					
					$msg = $msg . ' numFiles: ' . $zip->numFiles . "\n<br>";
										
					$file_upload_report = $file_upload_report . $msg;
					echo $msg;

					$validation_result = array();
					
					$validation_result['error']['error_count'] = 0;
					$validation_result['error']['rej_count'] = 0;
					$validation_result['error']['ack_count'] = 0;
					$validation_result['error']['error_msg'] = array();
					
					//FY15 upload change #1
					if (4 == $dataset_id){
						$valid_file_name_count = $valid_file_name_count_v4;
						$valid_file_names = $valid_file_names_v4;
						
						$validation_result['count']['adult_records'] = array();
						$validation_result['count']['child_records'] = array();
						$validation_result['count']['missing_DOB_records'] = array();
						$validation_result['count']['program_entries_records'] = array();
						$validation_result['count']['program_exits_records'] = array();
						$validation_result['count']['service_records'] = 0;
						
						$validation_result['project.csv']['data']['OrganizationID'] = array();
						$validation_result['project.csv']['data']['ProjectID'] = array();
						$validation_result['project.csv']['data']['ContinuumProject'] = array();
						$validation_result['project.csv']['data']['ProjectType'] = array();
						
						$validation_result['projectcoc.csv']['data']['ProjectID'] = array();
						$validation_result['projectcoc.csv']['data']['CoCCode'] = array();
						
						$validation_result['enrollment.csv']['data']['PersonalID'] = array();
						//enrollmentcoc
						$validation_result['client.csv']['data']['PersonalID'] = array();
						$validation_result['client.csv']['data']['DateOfBirth'] = array();
						//exit
						//$validation_result['incomebenefits.csv']['data']['IncomeBenefitType'] = array();
						$validation_result['incomebenefits.csv']['data']['PersonalID'] = array();
						
						
					} else {
						
						//$validation_result['count']['client_records'] = 0;
						$validation_result['count']['adult_records'] = array();
						$validation_result['count']['child_records'] = array();
						$validation_result['count']['missing_DOB_records'] = array();
						$validation_result['count']['program_entries_records'] = array();
						$validation_result['count']['program_exits_records'] = array();
						$validation_result['count']['service_records'] = 0;
						
						$validation_result['agencyprogram.csv']['data']['OrganizationID'] = array();
						$validation_result['agencyprogram.csv']['data']['ProgramID'] = array();
						$validation_result['client.csv']['data']['PersonalIdentificationNumber'] = array();
						$validation_result['client.csv']['data']['DateOfBirth'] = array();
						$validation_result['serviceevent.csv']['data']['ServiceEventStartDate'] = array();
						$validation_result['serviceevent.csv']['data']['ServiceEventType'] = array();
						$validation_result['serviceevent.csv']['data']['ServiceCode'] = array();
						$validation_result['programparticipation.csv']['data']['PersonalIdentificationNumber'] = array();
						$validation_result['programparticipation.csv']['data']['EntryDate'] = array();
						$validation_result['programparticipation.csv']['data']['IsAdult'] = array();
						$validation_result['programparticipation.csv']['data']['AdultCount'] = 0;
						$validation_result['programparticipation.csv']['data']['ExitDate'] = array();
						$validation_result['incomebenefits.csv']['data']['IncomeBenefitType'] = array();
	
						$validation_result['incomebenefits.csv']['data']['PersonalIdentificationNumber'] = array();
						$validation_result['clienthistorical.csv']['data']['PersonalIdentificationNumber'] = array();
						$validation_result['serviceevent.csv']['data']['PersonalIdentificationNumber'] = array();
						
						//$validation_result['client.csv']['missing_LegalFirstName'] = 0;
					}
					
					
					if (is_dir($tmp_work_unzip_dir)) {
						if ($dh = opendir($tmp_work_unzip_dir)) {
							$num = 0;
							$valid_file_count = 0;
							while ( ($file = readdir($dh)) !== false ) {
								if ( !(('.' == $file) || ('..' == $file)) ) {
									$num++;
									$msg = 'Index ' . $num . ": $file <br>";
									$file_upload_report = $file_upload_report . $msg;
									echo $msg; 
									
									$new_file_name =  strtolower (str_replace('_', '', $file));
									
									$validation_result["$new_file_name"]['rej_msg'] = array();
									$validation_result["$new_file_name"]['ack_msg'] = array();
									$validation_result["$new_file_name"]['error_msg'] = array();
									
									//FY15 upload change #2
									if (4 == $dataset_id){
										if ($valid_file_names_v4[0] == $new_file_name) {
											$file_names[0] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[1] == $new_file_name) {
											$file_names[1] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[2] == $new_file_name) {
											$file_names[2] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[3] == $new_file_name) {
											$file_names[3] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[4] == $new_file_name) {
											$file_names[4] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[5] == $new_file_name) {
											$file_names[5] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[6] == $new_file_name) {
											$file_names[6] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[7] == $new_file_name) {
											$file_names[7] = $file;
											$valid_file_count++;
										} else if ($valid_file_names_v4[8] == $new_file_name) {
											$file_names[8] = $file;
											$valid_file_count++;
										} else {
											
										}
									} else {
										if ($valid_file_names[0] == $new_file_name) {
											$file_names[0] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[1] == $new_file_name) {
											$file_names[1] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[2] == $new_file_name) {
											$file_names[2] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[3] == $new_file_name) {
											$file_names[3] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[4] == $new_file_name) {
											$file_names[4] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[5] == $new_file_name) {
											$file_names[5] = $file;
											$valid_file_count++;
										} else if ($valid_file_names[6] == $new_file_name) {
											$file_names[6] = $file;
											$valid_file_count++;
										} else {
											
										}
									}
								}
							}
							closedir($dh);
						}
					}
					
					if ($valid_file_name_count != $valid_file_count){
						
						for ($i=0; $i < $valid_file_name_count; $i++) {
							if ( empty($file_names[$i]) ) {
								$msg = '<br><font color="red"><b>Error: ' . $valid_file_names[$i] . ' file is missing. Please check and re-upload.</b></font>';
								$file_upload_report = $file_upload_report . $msg;
								echo $msg;
							}
						}
												
						delete_hmis_files($tmp_work_dir);
						
						if ( isset($_SESSION['uniq_id']) ) { 
							
							unset($_SESSION['uniq_id']);
							unset($uniq_id);
						}
						
						echo '<br><br><A HREF="/hmis/upload_v4.php">CSV Upload FY15 Data</A> | <A HREF="/menu.php">Repository Home</A>';
						print_footer();
						Exit("Error: Missing required files.");
					}
					
					$msg = '<br><br><b>Step 3. Validate File</b><br><br>';		
					$file_upload_report = $file_upload_report . $msg;
					echo $msg;

					for ($i=0; $i < $valid_file_name_count; $i++) {
					
						$num = $i + 1;
						$msg = ' <br><b>File ' . $num . ':</b> ';
												
						//FY15 upload change 3
						if (4 == $dataset_id){
							$hmis_validator = new HMISValidator($valid_file_names_v4);
							
							$validation_result = $hmis_validator->validate_v4($file_names[$i], $tmp_work_unzip_dir, $validation_result, $dataset_id);	//$format_version
						} else {
							$hmis_validator = new HMISValidator($valid_file_names);
							
							$validation_result = $hmis_validator->validate($file_names[$i], $tmp_work_unzip_dir, $validation_result, $dataset_id);	//$format_version
						}
						
					}

					$zip->close();
					
					$tot_err_cnt = $validation_result['error']['error_count'];
					$tot_rej_cnt = $validation_result['error']['rej_count'];
					$tot_ack_cnt = $validation_result['error']['ack_count'];
					
					//$msg = '<br><br>' . $spacer . '<b>[ Validation Result Summary ]</b><br>';
					$msg = '<br><br><b>[ Validation Result Summary ]</b><br><br>';
					$file_upload_report = $file_upload_report . $msg;
					echo $msg;
					$delete_hmis_files = FALSE;
					
					
					//FY15 upload change 4
					if (4 == $dataset_id){
						$num_client_records = count(array_unique($validation_result['client.csv']['data']['PersonalID'])) - 1;
					} else {
						$num_client_records = count(array_unique($validation_result['client.csv']['data']['PersonalIdentificationNumber'])) - 1;
						//increment 3 Data Summary

						$msg = $spacer . '<b>Data Summary</b><br>';
						//$msg = $msg . $spacer . $validation_result['count']['client_records'] . ' client records<br>';
					
					
					$num_adult_records = count(array_unique($validation_result['count']['adult_records']));
					$num_child_records = count(array_unique($validation_result['count']['child_records']));
					$num_missing_dobs = count(array_unique($validation_result['count']['missing_DOB_records']));
					$num_program_entries = count(array_unique($validation_result['count']['program_entries_records']));
					$num_program_exits = count(array_unique($validation_result['count']['program_exits_records']));
					
					
					
					$msg = $msg . $spacer . $num_client_records . ' client records<br>';
					$msg = $msg . $spacer . $spacer . $num_adult_records . ' adult record(s)<br>';
					$msg = $msg . $spacer . $spacer . $num_child_records . ' child record(s)<br>';
					$msg = $msg . $spacer . $spacer . $num_missing_dobs . ' missing DOB<br>';
					$msg = $msg . $spacer . $num_program_entries . ' program entries<br>';
					$msg = $msg . $spacer . $num_program_exits . ' program exit(s)<br>';
					$msg = $msg . $spacer . $validation_result['count']['service_records']. ' service record(s)<br><br>';
					
					
					$file_upload_report = $file_upload_report . $msg;
					echo $msg;
					}
					
					$msg_types = array('ack_msg', 'rej_msg', 'error_msg');
					
					//FY15 upload change 5
					if (4 == $dataset_id){
						$file_names = $valid_file_names_v4;	
					} else {
						$file_names = $valid_file_names;	
					}
					
					$msg = '';
					
					foreach($msg_types as $mt) {
						$tot_counter = 0;
						
						if ( 'ack_msg' == $mt ) {
							$msg .= '<b><font color=green> Data Quality Alerts </font></b> <br><br>';
						} else if ( 'rej_msg' == $mt ) {
							$msg .= '<b><font color=red> Validation Errors </font></b> <br><br>';
						} else if ( 'error_msg' == $mt ) {
							$msg .= '<b><font color=red> File Errors </font></b> <br><br>';
							
							if ( 0 < count ($validation_result['error']['error_msg']) ) {
								$counter = 1;
								$tot_counter++;
								foreach($validation_result['error']['error_msg'] as $ge) {
									$msg .=  '<b>' . $counter . '.</b> ' . $ge . '<br><br>';
									$counter++;
									
								}
							}
						}
					
					
						foreach($file_names as $fn) {
							
							$counter = 1;
							$new_file_name =  strtolower (str_replace('_', '', $fn));
							
							if ( 0 < count ($validation_result["$new_file_name"]["$mt"]) ) {
								$msg .=  '<b>[' . $fn . ']</b> : <br><br>';
								$tot_counter++;
								foreach($validation_result["$new_file_name"]["$mt"] as $ack_error) {
									$msg .=  '<b>' . $counter . '.</b> ' . $ack_error . '<br><br>';
									$counter++;
								}
								$msg .=  '<br>';
							}
						} 
						if ( 0 == $tot_counter ) {
							$msg .=  '<b><font color=blue>No issue found.</font></b><br><br>';
						}
     					}
     					
     					echo $msg;
     					$file_upload_report = $file_upload_report . $msg;
     					$send_email = 1;
     					
					echo '<br><br>';
					
					if ( 0 == $tot_err_cnt && 0 == $tot_rej_cnt && 0 == $tot_ack_cnt ) {
						$send_email = 0;
						$msg = $spacer . '<b><font color=blue>No issues found. </font></b>';
						$file_upload_report = $file_upload_report . $msg;
						echo $msg;
												
						if ( 'validate_upload' == $option ) {
							echo '<br><br><br>';
							insert_validated_data($file_name,$program_id,$dataset_id);
						} else {
							$msg = $spacer . '<b><font color=blue>Click the button below to process uploaded data files. </font></b><br>';
							$file_upload_report = $file_upload_report . $msg;
							echo $msg;
							
							print_ajax_header();
							print_ajax_form($file_name,$program_id,$dataset_id,$format_version);
						}
						
						$message = 'User file validation successful';
						audit_log($userID, $message, 59, $uniqid, $program_id);
												
					} else {
						
						if ( 0 != $tot_err_cnt ) {
							$msg = $spacer . '<b><font color=red>' . $tot_err_cnt . ' file error(s) found.</font></b> File upload is rejected and removed from the server.<br>';
							$file_upload_report = $file_upload_report . $msg;
							echo $msg;
							$delete_hmis_files = TRUE;
							
						}
						
						if ( 0 != $tot_rej_cnt ) {
							$msg = $spacer . '<b><font color=red>' . $tot_rej_cnt . ' rejection error(s) found.</font></b> File upload is rejected and removed from the server.<br>';
							$file_upload_report = $file_upload_report . $msg;
							echo $msg;
							$delete_hmis_files = TRUE;
							
						}
						
						if ( 0 < $tot_err_cnt || 0 < $tot_rej_cnt ) {
							$message = 'User file validation unsuccessful';
							audit_log($userID, $message, 58, $uniqid, $program_id);
						}
						
						
						if ( 0 != $tot_ack_cnt ) {
							$msg = $spacer . '<b><font color=green>' . $tot_ack_cnt . ' acknowledgement error(s) found.</font></b><br>';
							$file_upload_report = $file_upload_report . $msg;
							echo $msg;
							
							if ( 0 == $tot_rej_cnt &&  0 == $tot_err_cnt) {

								$send_email = 0;
								$message = 'User file validation successful (ack)';
								audit_log($userID, $message, 60, $uniqid, $program_id);
								
								if ( 'validate_upload' == $option ) {
									$msg = $spacer . 'Skipping acknowledgement...';
									$file_upload_report = $file_upload_report . $msg;
									echo $msg;
									
									echo '<br><br><br>';
									insert_validated_data($file_name,$program_id,$dataset_id);
								} else {
									$msg = '<br>' . $spacer . '<b><font color=blue>Click the button below to process uploaded data files. </font></b><br>';
									$msg .= $spacer . 'File upload requires your acknowledgement of these issues.';
									$file_upload_report = $file_upload_report . $msg;
									echo $msg;
									
									print_ajax_header();
									print_ajax_form($file_name,$program_id,$dataset_id,$format_version);
								}
								
								$delete_hmis_files = FALSE;
								
							}
						}
						
					}
															
				} else {
	    				$msg = '<font color="red">Unable to unzip file.  <br>Please check your zip file; it may have been corrupted. <br>File Name: </font>' . $file_name;	//. $tmp_work_dir 
						$file_upload_report = $file_upload_report . $msg;
						echo $msg;
				}
      			}
    		}
  	} else {
  		$file_name = scrub_white_list($_FILES['file']['name'], 'FILENAME');
		$file_type = scrub_white_list($_FILES['file']['type'], 'FILENAME');
			
  		if ( 50 < strlen($_FILES['file']['name'])) {
  			$msg = '<font color="red">Unable to upload.  <br>The name of the file that you selected is too long (more than 128 characters).  <br>Please rename your zip file and try the upload again.</font><br>File Name: ' . $file_name;
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
  		} else {
  			$msg = '<font color="red">Unable to upload.  <br>The zip file is larger than the current limit.  <br>Please contact <a href="../support.php">technical support</a>. </font>' . $file_type;
			$file_upload_report = $file_upload_report . $msg;
			echo $msg;
  		}	
  		print_footer();
  		
  		exit;
  	}	

  	if ($delete_hmis_files) {
  		delete_hmis_files($tmp_work_dir);
  	}
	
	$msg = '</td></tr></table> <br><br><HR><CENTER>';
	$file_upload_report = $file_upload_report . $msg;
	echo $msg;
	echo '<A HREF="/hmis/">CSV Upload FY15 Data</A> | <A HREF="/menu.php">Repository Home</A></CENTER>';
	
	$headers = "From: Repository <noreply@domain>\n" . "MIME-Version: 1.0\n" . "Content-type: text/html; charset=iso-8859-1";
	$html_msg = '<html><body>' . $file_upload_report . '</body></html>';
	
	if (1 == $send_email) {	//waiting confirmaiton from Molly - 02/18/2015
		mail($hmis_csv_report_email, 'HMIS file upload report (V. '.$dataset_id.'): ' . SERVER_ENV, $html_msg, $headers);
	}
	
	capture_upload_report($userID,$file_upload_report);
	
  	if ( isset($_SESSION['uniq_id']) ) { 
		unset($_SESSION['uniq_id']);
		unset($uniq_id);
	}
	
	print_footer();

}

?>
