<?php

	//require_once('/var/hmis_libs/config.php');
	include('../init.php');
	require_once('libs/functions.php');
	require_once('libs/soap/nusoap.php');

	if ( 'search' == $_GET['req'] ) {
		
		$hmis_id = scrub_sql(scrub_white_list($_GET['hmis_id'], 'ALPHANUMERICONLY'), 15);
		$user_id = scrub_sql(scrub_white_list($_GET['uldr'], 'NUMBERONLY'), 26); 
		$fname = scrub_sql(scrub_white_list($_GET['fname'], 'ALPHAONLY'), 26);
		$mname = scrub_sql(scrub_white_list($_GET['mname'], 'ALPHAONLY'), 26);
		$lname = scrub_sql(scrub_white_list($_GET['lname'], 'ALPHAONLY'), 26);
		$ssn = scrub_sql(scrub_white_list($_REQUEST['ssn'], 'NUMBERONLY'), 9);
		$gender = scrub_sql(scrub_white_list($_REQUEST['gender'], 'ALPHAONLY'), 1);
		$dob = scrub_sql(scrub_white_list($_REQUEST['dob'], 'BASIC'), 10);
		$zip = scrub_sql(scrub_white_list($_REQUEST['zip'], 'NUMBERONLY'), 5);
		//increment 3 $export_date = scrub_white_list($_GET['export_date'], 'BASIC');
		$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
		
		if (!is_numeric($user_id)) {
			echo 'Error. Invalid uldr: ' . $user_id;
			exit;
		}
		
		$sql = 'SELECT u.user_id, coc.coc_id, tc.Name 
			FROM tb_user u, tb_user_CoC coc, tb_CoC tc 
			WHERE u.user_id = coc.user_id and coc.coc_id = tc.coc_id and u.user_id = ' . $user_id;

		$rs = $db->Execute($sql) or die ("<br>SQL failed");
		$coc_name = $rs->fields('Name');
		$coc_id = $rs->fields('coc_id');
		
		
		$message = 'SQUARES request sent';
		audit_log($user_id, $message, 13, $hmis_id, $coc_id);

		$client = new nusoap_client($url, 'wsdl');
		
		$client->authtype = 'certificate'; 
		$client->certRequest['sslcertfile']= $pitc_cert;
		$client->certRequest['passphrase']='';
		$client->certRequest['sslkeyfile']=$pitc_key;
		$client->certRequest['cainfofile']=$pitc_ca;
		$client->certRequest['verifypeer']=1;
		$client->certRequest['verifyhost']=1;
		$client->certRequest['trace']=1;

		
		$error = $client->getError();
		if ($error) {
		    echo "<h2>Constructor error</h2><pre>" . $error . "</pre>";
		    
		}
		 
		
		$params = array(
		    'ssn' => '',
		    'firstName' => '',
		    'lastName' => '',
		    'middleName' => '',
		    'dateOfBirth'         => '',
		    'gender'         => '',
		    'lastzip'         => '',
		);
		
		
		$vadir_soapmsg = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:vdr="http://www.domain/schema/vdrPotentialVeteranSearchService">
		   <soapenv:Header/>
		   <soapenv:Body>
		      <vdr:SearchByCriteria>
			 <vdr:criteria>
			    <vdr:ssn>' . $ssn . '</vdr:ssn>
			    <vdr:firstName>' . $fname . '</vdr:firstName>
			    <vdr:lastName>' . $lname . '</vdr:lastName>
			    <vdr:middleName>' . $mname . '</vdr:middleName>
			    <vdr:dateOfBirth>' . $dob . '</vdr:dateOfBirth>
			    <vdr:gender>' . $gender . '</vdr:gender>
			    <vdr:lastZip>' . $zip . '</vdr:lastZip>
			    
			 </vdr:criteria>
		      </vdr:SearchByCriteria>
		   </soapenv:Body>
		</soapenv:Envelope>
		';
		
		$result = $client->vadir_call("SearchByCriteria", $params, $vadir_soapmsg);	
		if ($client->fault) {
		    echo "<h2>Fault</h2><pre>";
		    
		    $message = 'Error: Please check the data format';
		    echo $message;
		    echo "</pre>";
		    
		}
		else {
		    $error = $client->getError();
		    if ($error) {
			echo "<h2>Error</h2><pre>" . $error . "</pre>";
			$message = 'Error: ' . $error;
		    }
		    else {
			echo "<h2>Search Result</h2><pre>";
			$squares_result = $result[SearchByCriteriaReturn][result];
			
			if ( 1 == $squares_result ){
				
				$squares_text_result = '<font color = "blue"><b>Yes</b> <br>A matching Veteran record found in a VA Identity Repository</font>';
				$message = 'Yes';
			} else if ( '' == $squares_result ){
				
				$squares_text_result = '<b>Error</b>. Please try again. If problem continues, please contact HMIS Support.';
				$message = 'Error';
			} else if ( 0 == $squares_result ) {
				
				$squares_text_result = '<font color = "red"><b>No</b> <br>No matching Veteran record found in a VA Identity Repository</font>';
				$message = 'No';
			} else if ( 9 == $squares_result || 'X' == upper($squares_result) ) {
				
				$squares_text_result = '<font color = "red"><b>Inconclusive</b> <br>A matching Veteran record found in other sources but cannot be verified as a Veteran within the VA</font>';
				$message = 'Inconclusive';
			} else {
				
				$squares_text_result = '<b>Error</b>. Please try again. If problem continues, please contact HMIS Support.';
				$message = 'Error';
			}
			echo '<br>Probable Veteran? ' . $squares_text_result . '<br>';
			echo "</pre>";
			
		    }
		}
		
		if ('Error' == $message) {
			$message = $message . ' - ' . htmlspecialchars($client->response, ENT_QUOTES);
		}
		$message = 'SQUARES response: ' . $message;
		audit_log($user_id, scrub_sql(scrub_white_list($message, 'DATA'), 120), 14, scrub_sql(scrub_white_list($squares_result, 'ALPHANUMERICONLY'), 1)); //SQUARES response

		
	} else {
		$result = 'Error. Invalid Request Type';
	}

	exit;
?>
