package gov.va.med.hac.edi.ewv2.utils;


import gov.va.med.hac.edi.ewv2.exceptions.ActionErrorException;
import gov.va.med.hac.edi.ewv2.exceptions.NonUniqueRecordsException;
import gov.va.med.hac.edi.ewv2.persistence.EwvReference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.model.SelectItem;
import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Name("Ewv2ReferenceDocuments")
@Scope(ScopeType.SESSION)
public class ReferenceDocuments implements Serializable
{
    @Logger
    protected Log log;
    
    private static final long serialVersionUID = -2046592591578029243L;
    private ArrayList<EwvReference> docList = new ArrayList<EwvReference>(0);
    private boolean loaded = false;
    
    public void onLoad() throws ActionErrorException, NonUniqueRecordsException
    {
        if(!loaded)
        {
           
        	this.docList = getReferenceRecord();
        	
        	if(docList.size() > 0)
            {
                // int numberOfDocs = Integer.parseInt(numberOf);
            	log.info("Return Reference Count from database ", this.docList.size()); 
            }
            else
            {
                log.error("There are no database Reference records...");
            }
        }
        
        loaded = (this.docList.size() > 0);
    }
    
    public boolean shouldLoad() throws ActionErrorException, NonUniqueRecordsException
    {
        if(!this.loaded)
        {
            this.onLoad();
        }
        
        return true;
    }
    
    public List<SelectItem> getDocumentReferences()
    {
        List<SelectItem> list = new ArrayList<SelectItem>(0);    
        
        for (EwvReference docRef : this.docList)
        {
            SelectItem item = new SelectItem();
            
            item.setLabel(docRef.getReferenceLabel());
            item.setValue(docRef.getReferenceUrl());
            
            list.add(item);
        }
        
        return list;
    }
    
	  @In(create = true)
	  protected EntityManager entityManager;
	  
	  @SuppressWarnings("unchecked")
	public ArrayList<EwvReference> getReferenceRecord() throws ActionErrorException, NonUniqueRecordsException
	  {
	      ArrayList<EwvReference> retList = null;
	      String queryString ="select reference from EwvReference as reference where reference.active = :active";
	      try {
	          Query query = entityManager.createQuery(queryString);
	          query.setParameter("active", 1);
	          retList = (ArrayList<EwvReference>) query.getResultList();
	      } catch (Throwable t) {
	          if (t instanceof javax.persistence.NoResultException)
	          {
	              log.info("cannot get record for Reference: ");
	          }
	          else if(t instanceof javax.persistence.NonUniqueResultException)
	          {
	              log.error("more than 1 Reference exists for active: ");
	              
	              // this means that there are crap claim records in DB
	              throw new NonUniqueRecordsException("more than 1 Reference exists for active: ");
	          }
	          else
	          {
	              // log exception and route user to error page
	              handleException();
	          }
	      }
	      
	      return retList;
	  }
	  
	  private void handleException() {
			// TODO Auto-generated method stub
			
	  }
		  

}
