package gov.va.med.hac.edi.ewv2.utils;

import gov.va.med.hac.edi.ewv2.actions.AllClaimInfoAction;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.jboss.seam.Component;

public class PdiValidator implements Validator 
{

    public void validate(FacesContext context, UIComponent arg1, Object object)
      throws ValidatorException
    {
      FacesMessage returnMessage = null;
    
      if(object instanceof String)
      {
          String pdiString = (String)object;
          
          // Remove spaces from the string
          pdiString = pdiString.replace(" ", "");
          
          // Check length of the string
          int pdiStringLength = pdiString.length();
          if (pdiStringLength != 15) {
            fail("The PDI must be 15 digits long, not " + pdiStringLength);
          }
          
          // Check that all characters are digits
          for (int i = 0; i < pdiStringLength; i++) {
            if (!Character.isDigit(pdiString.charAt(i))) {
              fail ("All characters of the PDI must be digits.");
            }
          }
          
      // This probably can never happen.
      } else {
        returnMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR,"Unexplained Error", "");   
        throw new ValidatorException (returnMessage);
      }
    }

    private void fail(String msgString)
    {
      FacesMessage newMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR,msgString, "");

      fail(newMessage);
    }
    
    private void fail(FacesMessage msg)
    {
      // Invalidate the view, in case a previous claim was being viewed
      AllClaimInfoAction action = (AllClaimInfoAction)Component.getInstance("Ewv2AllClaimInfoAction");
      action.invalidate();
        
      // End processing
      throw new ValidatorException(msg);
    }
    
}
