package gov.va.med.hac.edi.ewv2.utils;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.model.SelectItem;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Name("Ewv2PDFDocuments")
@Scope(ScopeType.SESSION)
public class PdfReferenceDocuments implements Serializable
{
    @Logger
    protected Log log;
    
    private static final long serialVersionUID = -2046592591578029243L;
    private ArrayList<PdfDocument> docList = new ArrayList<PdfDocument>(0);
    private boolean loaded = false;
    
    public void onLoad()
    {
        if(!loaded)
        {
            BundleReader reader = BundleReader.getInstance("documents");
            
            String numberOf = reader.getProperty("number.of.documents");
            
            if(numberOf != null && this.isValidNumber(numberOf))
            {
                int numberOfDocs = Integer.parseInt(numberOf);
                
                for(int x=1;x<=numberOfDocs;x++)
                {
                    String docName = reader.getProperty("document."+x+".name");
                    String docReference = reader.getProperty("document."+x+".reference");
                    
                    if((docName != null) && (docReference != null))
                    {
                       this.docList.add(new PdfDocument(docName,docReference));
                    }
                    else
                    {
                        log.error("required properties for document number: "+x+" are missing!");
                    }
                }
            }
            else
            {
                log.error("documents property bundle is not properly configured...");
            }
        }
        
        loaded = (this.docList.size() > 0);
    }
    
    public boolean shouldLoad()
    {
        if(!this.loaded)
        {
            this.onLoad();
        }
        
        return true;
    }
    
    private boolean isValidNumber(String numberOf)
    {
        boolean ret = true;
        
        for(int x=0;x<=(numberOf.length()-1);x++)
        {
            char c = numberOf.charAt(x);
            
            if(!Character.isDigit(c))
            {
                ret = false;
                break;
            }
        }
        
        return ret;
    }

    public List<SelectItem> getDocumentReferences()
    {
        List<SelectItem> list = new ArrayList<SelectItem>(0);
        
        for (PdfDocument docRef : this.docList)
        {
            SelectItem item = new SelectItem();
            
            item.setLabel(docRef.getDocName());
            item.setValue(docRef.getDocReference());
            
            list.add(item);
        }
        
        return list;
    }
}
